/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.VendorStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchVendorsRequestFilter {
    private final Optional<List<String>> name;
    private final Optional<List<VendorStatus>> status;
    private final Map<String, Object> additionalProperties;

    private SearchVendorsRequestFilter(Optional<List<String>> name, Optional<List<VendorStatus>> status, Map<String, Object> additionalProperties) {
        this.name = name;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<List<VendorStatus>> getStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<List<String>> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status")
    private Optional<List<VendorStatus>> _getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchVendorsRequestFilter && this.equalTo((SearchVendorsRequestFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchVendorsRequestFilter other) {
        return this.name.equals(other.name) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> name = Optional.empty();
        private Optional<List<VendorStatus>> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchVendorsRequestFilter other) {
            this.name(other.getName());
            this.status(other.getStatus());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<List<String>> name) {
            this.name = name;
            return this;
        }

        public Builder name(List<String> name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<List<String>> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<List<VendorStatus>> status) {
            this.status = status;
            return this;
        }

        public Builder status(List<VendorStatus> status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Nullable<List<VendorStatus>> status) {
            this.status = status.isNull() ? null : (status.isEmpty() ? Optional.empty() : Optional.of(status.get()));
            return this;
        }

        public SearchVendorsRequestFilter build() {
            return new SearchVendorsRequestFilter(this.name, this.status, this.additionalProperties);
        }
    }
}

