/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchVendorsRequestFilter;
import com.squareup.square.types.SearchVendorsRequestSort;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchVendorsRequest {
    private final Optional<SearchVendorsRequestFilter> filter;
    private final Optional<SearchVendorsRequestSort> sort;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private SearchVendorsRequest(Optional<SearchVendorsRequestFilter> filter, Optional<SearchVendorsRequestSort> sort, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.sort = sort;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public Optional<SearchVendorsRequestFilter> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="sort")
    public Optional<SearchVendorsRequestSort> getSort() {
        return this.sort;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchVendorsRequest && this.equalTo((SearchVendorsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchVendorsRequest other) {
        return this.filter.equals(other.filter) && this.sort.equals(other.sort) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<SearchVendorsRequestFilter> filter = Optional.empty();
        private Optional<SearchVendorsRequestSort> sort = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchVendorsRequest other) {
            this.filter(other.getFilter());
            this.sort(other.getSort());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="filter", nulls=Nulls.SKIP)
        public Builder filter(Optional<SearchVendorsRequestFilter> filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(SearchVendorsRequestFilter filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @JsonSetter(value="sort", nulls=Nulls.SKIP)
        public Builder sort(Optional<SearchVendorsRequestSort> sort) {
            this.sort = sort;
            return this;
        }

        public Builder sort(SearchVendorsRequestSort sort) {
            this.sort = Optional.ofNullable(sort);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public SearchVendorsRequest build() {
            return new SearchVendorsRequest(this.filter, this.sort, this.cursor, this.additionalProperties);
        }
    }
}

