/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TeamMemberStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchTeamMembersFilter {
    private final Optional<List<String>> locationIds;
    private final Optional<TeamMemberStatus> status;
    private final Optional<Boolean> isOwner;
    private final Map<String, Object> additionalProperties;

    private SearchTeamMembersFilter(Optional<List<String>> locationIds, Optional<TeamMemberStatus> status, Optional<Boolean> isOwner, Map<String, Object> additionalProperties) {
        this.locationIds = locationIds;
        this.status = status;
        this.isOwner = isOwner;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonProperty(value="status")
    public Optional<TeamMemberStatus> getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Optional<Boolean> getIsOwner() {
        if (this.isOwner == null) {
            return Optional.empty();
        }
        return this.isOwner;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<List<String>> _getLocationIds() {
        return this.locationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_owner")
    private Optional<Boolean> _getIsOwner() {
        return this.isOwner;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchTeamMembersFilter && this.equalTo((SearchTeamMembersFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchTeamMembersFilter other) {
        return this.locationIds.equals(other.locationIds) && this.status.equals(other.status) && this.isOwner.equals(other.isOwner);
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.status, this.isOwner);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> locationIds = Optional.empty();
        private Optional<TeamMemberStatus> status = Optional.empty();
        private Optional<Boolean> isOwner = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchTeamMembersFilter other) {
            this.locationIds(other.getLocationIds());
            this.status(other.getStatus());
            this.isOwner(other.getIsOwner());
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        public Builder locationIds(Nullable<List<String>> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<TeamMemberStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(TeamMemberStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="is_owner", nulls=Nulls.SKIP)
        public Builder isOwner(Optional<Boolean> isOwner) {
            this.isOwner = isOwner;
            return this;
        }

        public Builder isOwner(Boolean isOwner) {
            this.isOwner = Optional.ofNullable(isOwner);
            return this;
        }

        public Builder isOwner(Nullable<Boolean> isOwner) {
            this.isOwner = isOwner.isNull() ? null : (isOwner.isEmpty() ? Optional.empty() : Optional.of(isOwner.get()));
            return this;
        }

        public SearchTeamMembersFilter build() {
            return new SearchTeamMembersFilter(this.locationIds, this.status, this.isOwner, this.additionalProperties);
        }
    }
}

