/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchSubscriptionsFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchSubscriptionsQuery {
    private final Optional<SearchSubscriptionsFilter> filter;
    private final Map<String, Object> additionalProperties;

    private SearchSubscriptionsQuery(Optional<SearchSubscriptionsFilter> filter, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public Optional<SearchSubscriptionsFilter> getFilter() {
        return this.filter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchSubscriptionsQuery && this.equalTo((SearchSubscriptionsQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchSubscriptionsQuery other) {
        return this.filter.equals(other.filter);
    }

    public int hashCode() {
        return Objects.hash(this.filter);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<SearchSubscriptionsFilter> filter = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchSubscriptionsQuery other) {
            this.filter(other.getFilter());
            return this;
        }

        @JsonSetter(value="filter", nulls=Nulls.SKIP)
        public Builder filter(Optional<SearchSubscriptionsFilter> filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(SearchSubscriptionsFilter filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        public SearchSubscriptionsQuery build() {
            return new SearchSubscriptionsQuery(this.filter, this.additionalProperties);
        }
    }
}

