/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchSubscriptionsFilter {
    private final Optional<List<String>> customerIds;
    private final Optional<List<String>> locationIds;
    private final Optional<List<String>> sourceNames;
    private final Map<String, Object> additionalProperties;

    private SearchSubscriptionsFilter(Optional<List<String>> customerIds, Optional<List<String>> locationIds, Optional<List<String>> sourceNames, Map<String, Object> additionalProperties) {
        this.customerIds = customerIds;
        this.locationIds = locationIds;
        this.sourceNames = sourceNames;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getCustomerIds() {
        if (this.customerIds == null) {
            return Optional.empty();
        }
        return this.customerIds;
    }

    @JsonIgnore
    public Optional<List<String>> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonIgnore
    public Optional<List<String>> getSourceNames() {
        if (this.sourceNames == null) {
            return Optional.empty();
        }
        return this.sourceNames;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_ids")
    private Optional<List<String>> _getCustomerIds() {
        return this.customerIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<List<String>> _getLocationIds() {
        return this.locationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_names")
    private Optional<List<String>> _getSourceNames() {
        return this.sourceNames;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchSubscriptionsFilter && this.equalTo((SearchSubscriptionsFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchSubscriptionsFilter other) {
        return this.customerIds.equals(other.customerIds) && this.locationIds.equals(other.locationIds) && this.sourceNames.equals(other.sourceNames);
    }

    public int hashCode() {
        return Objects.hash(this.customerIds, this.locationIds, this.sourceNames);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> customerIds = Optional.empty();
        private Optional<List<String>> locationIds = Optional.empty();
        private Optional<List<String>> sourceNames = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchSubscriptionsFilter other) {
            this.customerIds(other.getCustomerIds());
            this.locationIds(other.getLocationIds());
            this.sourceNames(other.getSourceNames());
            return this;
        }

        @JsonSetter(value="customer_ids", nulls=Nulls.SKIP)
        public Builder customerIds(Optional<List<String>> customerIds) {
            this.customerIds = customerIds;
            return this;
        }

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = Optional.ofNullable(customerIds);
            return this;
        }

        public Builder customerIds(Nullable<List<String>> customerIds) {
            this.customerIds = customerIds.isNull() ? null : (customerIds.isEmpty() ? Optional.empty() : Optional.of(customerIds.get()));
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        public Builder locationIds(Nullable<List<String>> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        @JsonSetter(value="source_names", nulls=Nulls.SKIP)
        public Builder sourceNames(Optional<List<String>> sourceNames) {
            this.sourceNames = sourceNames;
            return this;
        }

        public Builder sourceNames(List<String> sourceNames) {
            this.sourceNames = Optional.ofNullable(sourceNames);
            return this;
        }

        public Builder sourceNames(Nullable<List<String>> sourceNames) {
            this.sourceNames = sourceNames.isNull() ? null : (sourceNames.isEmpty() ? Optional.empty() : Optional.of(sourceNames.get()));
            return this;
        }

        public SearchSubscriptionsFilter build() {
            return new SearchSubscriptionsFilter(this.customerIds, this.locationIds, this.sourceNames, this.additionalProperties);
        }
    }
}

