/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Shift;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchShiftsResponse {
    private final Optional<List<Shift>> shifts;
    private final Optional<String> cursor;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private SearchShiftsResponse(Optional<List<Shift>> shifts, Optional<String> cursor, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.shifts = shifts;
        this.cursor = cursor;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="shifts")
    public Optional<List<Shift>> getShifts() {
        return this.shifts;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchShiftsResponse && this.equalTo((SearchShiftsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchShiftsResponse other) {
        return this.shifts.equals(other.shifts) && this.cursor.equals(other.cursor) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.shifts, this.cursor, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Shift>> shifts = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchShiftsResponse other) {
            this.shifts(other.getShifts());
            this.cursor(other.getCursor());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="shifts", nulls=Nulls.SKIP)
        public Builder shifts(Optional<List<Shift>> shifts) {
            this.shifts = shifts;
            return this;
        }

        public Builder shifts(List<Shift> shifts) {
            this.shifts = Optional.ofNullable(shifts);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public SearchShiftsResponse build() {
            return new SearchShiftsResponse(this.shifts, this.cursor, this.errors, this.additionalProperties);
        }
    }
}

