/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.OrderState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchOrdersStateFilter {
    private final List<OrderState> states;
    private final Map<String, Object> additionalProperties;

    private SearchOrdersStateFilter(List<OrderState> states, Map<String, Object> additionalProperties) {
        this.states = states;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="states")
    public List<OrderState> getStates() {
        return this.states;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchOrdersStateFilter && this.equalTo((SearchOrdersStateFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchOrdersStateFilter other) {
        return this.states.equals(other.states);
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<OrderState> states = new ArrayList<OrderState>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchOrdersStateFilter other) {
            this.states(other.getStates());
            return this;
        }

        @JsonSetter(value="states", nulls=Nulls.SKIP)
        public Builder states(List<OrderState> states) {
            this.states.clear();
            this.states.addAll(states);
            return this;
        }

        public Builder addStates(OrderState states) {
            this.states.add(states);
            return this;
        }

        public Builder addAllStates(List<OrderState> states) {
            this.states.addAll(states);
            return this;
        }

        public SearchOrdersStateFilter build() {
            return new SearchOrdersStateFilter(this.states, this.additionalProperties);
        }
    }
}

