/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchOrdersSourceFilter {
    private final Optional<List<String>> sourceNames;
    private final Map<String, Object> additionalProperties;

    private SearchOrdersSourceFilter(Optional<List<String>> sourceNames, Map<String, Object> additionalProperties) {
        this.sourceNames = sourceNames;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getSourceNames() {
        if (this.sourceNames == null) {
            return Optional.empty();
        }
        return this.sourceNames;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_names")
    private Optional<List<String>> _getSourceNames() {
        return this.sourceNames;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchOrdersSourceFilter && this.equalTo((SearchOrdersSourceFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchOrdersSourceFilter other) {
        return this.sourceNames.equals(other.sourceNames);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNames);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> sourceNames = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchOrdersSourceFilter other) {
            this.sourceNames(other.getSourceNames());
            return this;
        }

        @JsonSetter(value="source_names", nulls=Nulls.SKIP)
        public Builder sourceNames(Optional<List<String>> sourceNames) {
            this.sourceNames = sourceNames;
            return this;
        }

        public Builder sourceNames(List<String> sourceNames) {
            this.sourceNames = Optional.ofNullable(sourceNames);
            return this;
        }

        public Builder sourceNames(Nullable<List<String>> sourceNames) {
            this.sourceNames = sourceNames.isNull() ? null : (sourceNames.isEmpty() ? Optional.empty() : Optional.of(sourceNames.get()));
            return this;
        }

        public SearchOrdersSourceFilter build() {
            return new SearchOrdersSourceFilter(this.sourceNames, this.additionalProperties);
        }
    }
}

