/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Order;
import com.squareup.square.types.OrderEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchOrdersResponse {
    private final Optional<List<OrderEntry>> orderEntries;
    private final Optional<List<Order>> orders;
    private final Optional<String> cursor;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private SearchOrdersResponse(Optional<List<OrderEntry>> orderEntries, Optional<List<Order>> orders, Optional<String> cursor, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.orderEntries = orderEntries;
        this.orders = orders;
        this.cursor = cursor;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_entries")
    public Optional<List<OrderEntry>> getOrderEntries() {
        return this.orderEntries;
    }

    @JsonProperty(value="orders")
    public Optional<List<Order>> getOrders() {
        return this.orders;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchOrdersResponse && this.equalTo((SearchOrdersResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchOrdersResponse other) {
        return this.orderEntries.equals(other.orderEntries) && this.orders.equals(other.orders) && this.cursor.equals(other.cursor) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.orderEntries, this.orders, this.cursor, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<OrderEntry>> orderEntries = Optional.empty();
        private Optional<List<Order>> orders = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchOrdersResponse other) {
            this.orderEntries(other.getOrderEntries());
            this.orders(other.getOrders());
            this.cursor(other.getCursor());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="order_entries", nulls=Nulls.SKIP)
        public Builder orderEntries(Optional<List<OrderEntry>> orderEntries) {
            this.orderEntries = orderEntries;
            return this;
        }

        public Builder orderEntries(List<OrderEntry> orderEntries) {
            this.orderEntries = Optional.ofNullable(orderEntries);
            return this;
        }

        @JsonSetter(value="orders", nulls=Nulls.SKIP)
        public Builder orders(Optional<List<Order>> orders) {
            this.orders = orders;
            return this;
        }

        public Builder orders(List<Order> orders) {
            this.orders = Optional.ofNullable(orders);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public SearchOrdersResponse build() {
            return new SearchOrdersResponse(this.orderEntries, this.orders, this.cursor, this.errors, this.additionalProperties);
        }
    }
}

