/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.FulfillmentState;
import com.squareup.square.types.FulfillmentType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchOrdersFulfillmentFilter {
    private final Optional<List<FulfillmentType>> fulfillmentTypes;
    private final Optional<List<FulfillmentState>> fulfillmentStates;
    private final Map<String, Object> additionalProperties;

    private SearchOrdersFulfillmentFilter(Optional<List<FulfillmentType>> fulfillmentTypes, Optional<List<FulfillmentState>> fulfillmentStates, Map<String, Object> additionalProperties) {
        this.fulfillmentTypes = fulfillmentTypes;
        this.fulfillmentStates = fulfillmentStates;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<FulfillmentType>> getFulfillmentTypes() {
        if (this.fulfillmentTypes == null) {
            return Optional.empty();
        }
        return this.fulfillmentTypes;
    }

    @JsonIgnore
    public Optional<List<FulfillmentState>> getFulfillmentStates() {
        if (this.fulfillmentStates == null) {
            return Optional.empty();
        }
        return this.fulfillmentStates;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fulfillment_types")
    private Optional<List<FulfillmentType>> _getFulfillmentTypes() {
        return this.fulfillmentTypes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fulfillment_states")
    private Optional<List<FulfillmentState>> _getFulfillmentStates() {
        return this.fulfillmentStates;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchOrdersFulfillmentFilter && this.equalTo((SearchOrdersFulfillmentFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchOrdersFulfillmentFilter other) {
        return this.fulfillmentTypes.equals(other.fulfillmentTypes) && this.fulfillmentStates.equals(other.fulfillmentStates);
    }

    public int hashCode() {
        return Objects.hash(this.fulfillmentTypes, this.fulfillmentStates);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<FulfillmentType>> fulfillmentTypes = Optional.empty();
        private Optional<List<FulfillmentState>> fulfillmentStates = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchOrdersFulfillmentFilter other) {
            this.fulfillmentTypes(other.getFulfillmentTypes());
            this.fulfillmentStates(other.getFulfillmentStates());
            return this;
        }

        @JsonSetter(value="fulfillment_types", nulls=Nulls.SKIP)
        public Builder fulfillmentTypes(Optional<List<FulfillmentType>> fulfillmentTypes) {
            this.fulfillmentTypes = fulfillmentTypes;
            return this;
        }

        public Builder fulfillmentTypes(List<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = Optional.ofNullable(fulfillmentTypes);
            return this;
        }

        public Builder fulfillmentTypes(Nullable<List<FulfillmentType>> fulfillmentTypes) {
            this.fulfillmentTypes = fulfillmentTypes.isNull() ? null : (fulfillmentTypes.isEmpty() ? Optional.empty() : Optional.of(fulfillmentTypes.get()));
            return this;
        }

        @JsonSetter(value="fulfillment_states", nulls=Nulls.SKIP)
        public Builder fulfillmentStates(Optional<List<FulfillmentState>> fulfillmentStates) {
            this.fulfillmentStates = fulfillmentStates;
            return this;
        }

        public Builder fulfillmentStates(List<FulfillmentState> fulfillmentStates) {
            this.fulfillmentStates = Optional.ofNullable(fulfillmentStates);
            return this;
        }

        public Builder fulfillmentStates(Nullable<List<FulfillmentState>> fulfillmentStates) {
            this.fulfillmentStates = fulfillmentStates.isNull() ? null : (fulfillmentStates.isEmpty() ? Optional.empty() : Optional.of(fulfillmentStates.get()));
            return this;
        }

        public SearchOrdersFulfillmentFilter build() {
            return new SearchOrdersFulfillmentFilter(this.fulfillmentTypes, this.fulfillmentStates, this.additionalProperties);
        }
    }
}

