/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyRewardStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchLoyaltyRewardsRequestLoyaltyRewardQuery {
    private final String loyaltyAccountId;
    private final Optional<LoyaltyRewardStatus> status;
    private final Map<String, Object> additionalProperties;

    private SearchLoyaltyRewardsRequestLoyaltyRewardQuery(String loyaltyAccountId, Optional<LoyaltyRewardStatus> status, Map<String, Object> additionalProperties) {
        this.loyaltyAccountId = loyaltyAccountId;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="loyalty_account_id")
    public String getLoyaltyAccountId() {
        return this.loyaltyAccountId;
    }

    @JsonProperty(value="status")
    public Optional<LoyaltyRewardStatus> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchLoyaltyRewardsRequestLoyaltyRewardQuery && this.equalTo((SearchLoyaltyRewardsRequestLoyaltyRewardQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchLoyaltyRewardsRequestLoyaltyRewardQuery other) {
        return this.loyaltyAccountId.equals(other.loyaltyAccountId) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyAccountId, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LoyaltyAccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LoyaltyAccountIdStage,
    _FinalStage {
        private String loyaltyAccountId;
        private Optional<LoyaltyRewardStatus> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SearchLoyaltyRewardsRequestLoyaltyRewardQuery other) {
            this.loyaltyAccountId(other.getLoyaltyAccountId());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="loyalty_account_id")
        public _FinalStage loyaltyAccountId(@NotNull String loyaltyAccountId) {
            this.loyaltyAccountId = Objects.requireNonNull(loyaltyAccountId, "loyaltyAccountId must not be null");
            return this;
        }

        @Override
        public _FinalStage status(LoyaltyRewardStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<LoyaltyRewardStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public SearchLoyaltyRewardsRequestLoyaltyRewardQuery build() {
            return new SearchLoyaltyRewardsRequestLoyaltyRewardQuery(this.loyaltyAccountId, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SearchLoyaltyRewardsRequestLoyaltyRewardQuery build();

        public _FinalStage status(Optional<LoyaltyRewardStatus> var1);

        public _FinalStage status(LoyaltyRewardStatus var1);
    }

    public static interface LoyaltyAccountIdStage {
        public _FinalStage loyaltyAccountId(@NotNull String var1);

        public Builder from(SearchLoyaltyRewardsRequestLoyaltyRewardQuery var1);
    }
}

