/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyAccountMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchLoyaltyAccountsRequestLoyaltyAccountQuery {
    private final Optional<List<LoyaltyAccountMapping>> mappings;
    private final Optional<List<String>> customerIds;
    private final Map<String, Object> additionalProperties;

    private SearchLoyaltyAccountsRequestLoyaltyAccountQuery(Optional<List<LoyaltyAccountMapping>> mappings, Optional<List<String>> customerIds, Map<String, Object> additionalProperties) {
        this.mappings = mappings;
        this.customerIds = customerIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<LoyaltyAccountMapping>> getMappings() {
        if (this.mappings == null) {
            return Optional.empty();
        }
        return this.mappings;
    }

    @JsonIgnore
    public Optional<List<String>> getCustomerIds() {
        if (this.customerIds == null) {
            return Optional.empty();
        }
        return this.customerIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="mappings")
    private Optional<List<LoyaltyAccountMapping>> _getMappings() {
        return this.mappings;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_ids")
    private Optional<List<String>> _getCustomerIds() {
        return this.customerIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchLoyaltyAccountsRequestLoyaltyAccountQuery && this.equalTo((SearchLoyaltyAccountsRequestLoyaltyAccountQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchLoyaltyAccountsRequestLoyaltyAccountQuery other) {
        return this.mappings.equals(other.mappings) && this.customerIds.equals(other.customerIds);
    }

    public int hashCode() {
        return Objects.hash(this.mappings, this.customerIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<LoyaltyAccountMapping>> mappings = Optional.empty();
        private Optional<List<String>> customerIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchLoyaltyAccountsRequestLoyaltyAccountQuery other) {
            this.mappings(other.getMappings());
            this.customerIds(other.getCustomerIds());
            return this;
        }

        @JsonSetter(value="mappings", nulls=Nulls.SKIP)
        public Builder mappings(Optional<List<LoyaltyAccountMapping>> mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder mappings(List<LoyaltyAccountMapping> mappings) {
            this.mappings = Optional.ofNullable(mappings);
            return this;
        }

        public Builder mappings(Nullable<List<LoyaltyAccountMapping>> mappings) {
            this.mappings = mappings.isNull() ? null : (mappings.isEmpty() ? Optional.empty() : Optional.of(mappings.get()));
            return this;
        }

        @JsonSetter(value="customer_ids", nulls=Nulls.SKIP)
        public Builder customerIds(Optional<List<String>> customerIds) {
            this.customerIds = customerIds;
            return this;
        }

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = Optional.ofNullable(customerIds);
            return this;
        }

        public Builder customerIds(Nullable<List<String>> customerIds) {
            this.customerIds = customerIds.isNull() ? null : (customerIds.isEmpty() ? Optional.empty() : Optional.of(customerIds.get()));
            return this;
        }

        public SearchLoyaltyAccountsRequestLoyaltyAccountQuery build() {
            return new SearchLoyaltyAccountsRequestLoyaltyAccountQuery(this.mappings, this.customerIds, this.additionalProperties);
        }
    }
}

