/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InvoiceQuery;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchInvoicesRequest {
    private final InvoiceQuery query;
    private final Optional<Integer> limit;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private SearchInvoicesRequest(InvoiceQuery query, Optional<Integer> limit, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.query = query;
        this.limit = limit;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="query")
    public InvoiceQuery getQuery() {
        return this.query;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchInvoicesRequest && this.equalTo((SearchInvoicesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchInvoicesRequest other) {
        return this.query.equals(other.query) && this.limit.equals(other.limit) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.limit, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QueryStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements QueryStage,
    _FinalStage {
        private InvoiceQuery query;
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SearchInvoicesRequest other) {
            this.query(other.getQuery());
            this.limit(other.getLimit());
            this.cursor(other.getCursor());
            return this;
        }

        @Override
        @JsonSetter(value="query")
        public _FinalStage query(@NotNull InvoiceQuery query) {
            this.query = Objects.requireNonNull(query, "query must not be null");
            return this;
        }

        @Override
        public _FinalStage cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @Override
        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public _FinalStage cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public SearchInvoicesRequest build() {
            return new SearchInvoicesRequest(this.query, this.limit, this.cursor, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SearchInvoicesRequest build();

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage cursor(Optional<String> var1);

        public _FinalStage cursor(String var1);
    }

    public static interface QueryStage {
        public _FinalStage query(@NotNull InvoiceQuery var1);

        public Builder from(SearchInvoicesRequest var1);
    }
}

