/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Availability;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchAvailabilityResponse {
    private final Optional<List<Availability>> availabilities;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private SearchAvailabilityResponse(Optional<List<Availability>> availabilities, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.availabilities = availabilities;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="availabilities")
    public Optional<List<Availability>> getAvailabilities() {
        return this.availabilities;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchAvailabilityResponse && this.equalTo((SearchAvailabilityResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchAvailabilityResponse other) {
        return this.availabilities.equals(other.availabilities) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.availabilities, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Availability>> availabilities = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchAvailabilityResponse other) {
            this.availabilities(other.getAvailabilities());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="availabilities", nulls=Nulls.SKIP)
        public Builder availabilities(Optional<List<Availability>> availabilities) {
            this.availabilities = availabilities;
            return this;
        }

        public Builder availabilities(List<Availability> availabilities) {
            this.availabilities = Optional.ofNullable(availabilities);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public SearchAvailabilityResponse build() {
            return new SearchAvailabilityResponse(this.availabilities, this.errors, this.additionalProperties);
        }
    }
}

