/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchAvailabilityFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchAvailabilityQuery {
    private final SearchAvailabilityFilter filter;
    private final Map<String, Object> additionalProperties;

    private SearchAvailabilityQuery(SearchAvailabilityFilter filter, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public SearchAvailabilityFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchAvailabilityQuery && this.equalTo((SearchAvailabilityQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchAvailabilityQuery other) {
        return this.filter.equals(other.filter);
    }

    public int hashCode() {
        return Objects.hash(this.filter);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FilterStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FilterStage,
    _FinalStage {
        private SearchAvailabilityFilter filter;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SearchAvailabilityQuery other) {
            this.filter(other.getFilter());
            return this;
        }

        @Override
        @JsonSetter(value="filter")
        public _FinalStage filter(@NotNull SearchAvailabilityFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter must not be null");
            return this;
        }

        @Override
        public SearchAvailabilityQuery build() {
            return new SearchAvailabilityQuery(this.filter, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SearchAvailabilityQuery build();
    }

    public static interface FilterStage {
        public _FinalStage filter(@NotNull SearchAvailabilityFilter var1);

        public Builder from(SearchAvailabilityQuery var1);
    }
}

