/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.RiskEvaluationRiskLevel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RiskEvaluation {
    private final Optional<String> createdAt;
    private final Optional<RiskEvaluationRiskLevel> riskLevel;
    private final Map<String, Object> additionalProperties;

    private RiskEvaluation(Optional<String> createdAt, Optional<RiskEvaluationRiskLevel> riskLevel, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.riskLevel = riskLevel;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="risk_level")
    public Optional<RiskEvaluationRiskLevel> getRiskLevel() {
        return this.riskLevel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RiskEvaluation && this.equalTo((RiskEvaluation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RiskEvaluation other) {
        return this.createdAt.equals(other.createdAt) && this.riskLevel.equals(other.riskLevel);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.riskLevel);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> createdAt = Optional.empty();
        private Optional<RiskEvaluationRiskLevel> riskLevel = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RiskEvaluation other) {
            this.createdAt(other.getCreatedAt());
            this.riskLevel(other.getRiskLevel());
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="risk_level", nulls=Nulls.SKIP)
        public Builder riskLevel(Optional<RiskEvaluationRiskLevel> riskLevel) {
            this.riskLevel = riskLevel;
            return this;
        }

        public Builder riskLevel(RiskEvaluationRiskLevel riskLevel) {
            this.riskLevel = Optional.ofNullable(riskLevel);
            return this;
        }

        public RiskEvaluation build() {
            return new RiskEvaluation(this.createdAt, this.riskLevel, this.additionalProperties);
        }
    }
}

