/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RevokeTokenResponse {
    private final Optional<Boolean> success;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private RevokeTokenResponse(Optional<Boolean> success, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.success = success;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="success")
    public Optional<Boolean> getSuccess() {
        return this.success;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RevokeTokenResponse && this.equalTo((RevokeTokenResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RevokeTokenResponse other) {
        return this.success.equals(other.success) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> success = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RevokeTokenResponse other) {
            this.success(other.getSuccess());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="success", nulls=Nulls.SKIP)
        public Builder success(Optional<Boolean> success) {
            this.success = success;
            return this;
        }

        public Builder success(Boolean success) {
            this.success = Optional.ofNullable(success);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public RevokeTokenResponse build() {
            return new RevokeTokenResponse(this.success, this.errors, this.additionalProperties);
        }
    }
}

