/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.PaymentRefund;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RefundPaymentResponse {
    private final Optional<List<Error>> errors;
    private final Optional<PaymentRefund> refund;
    private final Map<String, Object> additionalProperties;

    private RefundPaymentResponse(Optional<List<Error>> errors, Optional<PaymentRefund> refund, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.refund = refund;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="refund")
    public Optional<PaymentRefund> getRefund() {
        return this.refund;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RefundPaymentResponse && this.equalTo((RefundPaymentResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RefundPaymentResponse other) {
        return this.errors.equals(other.errors) && this.refund.equals(other.refund);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.refund);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<PaymentRefund> refund = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RefundPaymentResponse other) {
            this.errors(other.getErrors());
            this.refund(other.getRefund());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="refund", nulls=Nulls.SKIP)
        public Builder refund(Optional<PaymentRefund> refund) {
            this.refund = refund;
            return this;
        }

        public Builder refund(PaymentRefund refund) {
            this.refund = Optional.ofNullable(refund);
            return this;
        }

        public RefundPaymentResponse build() {
            return new RefundPaymentResponse(this.errors, this.refund, this.additionalProperties);
        }
    }
}

