/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ReceiptOptions {
    private final String paymentId;
    private final Optional<Boolean> printOnly;
    private final Optional<Boolean> isDuplicate;
    private final Map<String, Object> additionalProperties;

    private ReceiptOptions(String paymentId, Optional<Boolean> printOnly, Optional<Boolean> isDuplicate, Map<String, Object> additionalProperties) {
        this.paymentId = paymentId;
        this.printOnly = printOnly;
        this.isDuplicate = isDuplicate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payment_id")
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public Optional<Boolean> getPrintOnly() {
        if (this.printOnly == null) {
            return Optional.empty();
        }
        return this.printOnly;
    }

    @JsonIgnore
    public Optional<Boolean> getIsDuplicate() {
        if (this.isDuplicate == null) {
            return Optional.empty();
        }
        return this.isDuplicate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="print_only")
    private Optional<Boolean> _getPrintOnly() {
        return this.printOnly;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_duplicate")
    private Optional<Boolean> _getIsDuplicate() {
        return this.isDuplicate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ReceiptOptions && this.equalTo((ReceiptOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ReceiptOptions other) {
        return this.paymentId.equals(other.paymentId) && this.printOnly.equals(other.printOnly) && this.isDuplicate.equals(other.isDuplicate);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.printOnly, this.isDuplicate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PaymentIdStage,
    _FinalStage {
        private String paymentId;
        private Optional<Boolean> isDuplicate = Optional.empty();
        private Optional<Boolean> printOnly = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ReceiptOptions other) {
            this.paymentId(other.getPaymentId());
            this.printOnly(other.getPrintOnly());
            this.isDuplicate(other.getIsDuplicate());
            return this;
        }

        @Override
        @JsonSetter(value="payment_id")
        public _FinalStage paymentId(@NotNull String paymentId) {
            this.paymentId = Objects.requireNonNull(paymentId, "paymentId must not be null");
            return this;
        }

        @Override
        public _FinalStage isDuplicate(Nullable<Boolean> isDuplicate) {
            this.isDuplicate = isDuplicate.isNull() ? null : (isDuplicate.isEmpty() ? Optional.empty() : Optional.of(isDuplicate.get()));
            return this;
        }

        @Override
        public _FinalStage isDuplicate(Boolean isDuplicate) {
            this.isDuplicate = Optional.ofNullable(isDuplicate);
            return this;
        }

        @Override
        @JsonSetter(value="is_duplicate", nulls=Nulls.SKIP)
        public _FinalStage isDuplicate(Optional<Boolean> isDuplicate) {
            this.isDuplicate = isDuplicate;
            return this;
        }

        @Override
        public _FinalStage printOnly(Nullable<Boolean> printOnly) {
            this.printOnly = printOnly.isNull() ? null : (printOnly.isEmpty() ? Optional.empty() : Optional.of(printOnly.get()));
            return this;
        }

        @Override
        public _FinalStage printOnly(Boolean printOnly) {
            this.printOnly = Optional.ofNullable(printOnly);
            return this;
        }

        @Override
        @JsonSetter(value="print_only", nulls=Nulls.SKIP)
        public _FinalStage printOnly(Optional<Boolean> printOnly) {
            this.printOnly = printOnly;
            return this;
        }

        @Override
        public ReceiptOptions build() {
            return new ReceiptOptions(this.paymentId, this.printOnly, this.isDuplicate, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ReceiptOptions build();

        public _FinalStage printOnly(Optional<Boolean> var1);

        public _FinalStage printOnly(Boolean var1);

        public _FinalStage printOnly(Nullable<Boolean> var1);

        public _FinalStage isDuplicate(Optional<Boolean> var1);

        public _FinalStage isDuplicate(Boolean var1);

        public _FinalStage isDuplicate(Nullable<Boolean> var1);
    }

    public static interface PaymentIdStage {
        public _FinalStage paymentId(@NotNull String var1);

        public Builder from(ReceiptOptions var1);
    }
}

