/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class QuickPay {
    private final String name;
    private final Money priceMoney;
    private final String locationId;
    private final Map<String, Object> additionalProperties;

    private QuickPay(String name, Money priceMoney, String locationId, Map<String, Object> additionalProperties) {
        this.name = name;
        this.priceMoney = priceMoney;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="price_money")
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof QuickPay && this.equalTo((QuickPay)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(QuickPay other) {
        return this.name.equals(other.name) && this.priceMoney.equals(other.priceMoney) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.priceMoney, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    PriceMoneyStage,
    LocationIdStage,
    _FinalStage {
        private String name;
        private Money priceMoney;
        private String locationId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(QuickPay other) {
            this.name(other.getName());
            this.priceMoney(other.getPriceMoney());
            this.locationId(other.getLocationId());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriceMoneyStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price_money")
        public LocationIdStage priceMoney(@NotNull Money priceMoney) {
            this.priceMoney = Objects.requireNonNull(priceMoney, "priceMoney must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public QuickPay build() {
            return new QuickPay(this.name, this.priceMoney, this.locationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public QuickPay build();
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);
    }

    public static interface PriceMoneyStage {
        public LocationIdStage priceMoney(@NotNull Money var1);
    }

    public static interface NameStage {
        public PriceMoneyStage name(@NotNull String var1);

        public Builder from(QuickPay var1);
    }
}

