/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PrePopulatedData {
    private final Optional<String> buyerEmail;
    private final Optional<String> buyerPhoneNumber;
    private final Optional<Address> buyerAddress;
    private final Map<String, Object> additionalProperties;

    private PrePopulatedData(Optional<String> buyerEmail, Optional<String> buyerPhoneNumber, Optional<Address> buyerAddress, Map<String, Object> additionalProperties) {
        this.buyerEmail = buyerEmail;
        this.buyerPhoneNumber = buyerPhoneNumber;
        this.buyerAddress = buyerAddress;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getBuyerEmail() {
        if (this.buyerEmail == null) {
            return Optional.empty();
        }
        return this.buyerEmail;
    }

    @JsonIgnore
    public Optional<String> getBuyerPhoneNumber() {
        if (this.buyerPhoneNumber == null) {
            return Optional.empty();
        }
        return this.buyerPhoneNumber;
    }

    @JsonProperty(value="buyer_address")
    public Optional<Address> getBuyerAddress() {
        return this.buyerAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="buyer_email")
    private Optional<String> _getBuyerEmail() {
        return this.buyerEmail;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="buyer_phone_number")
    private Optional<String> _getBuyerPhoneNumber() {
        return this.buyerPhoneNumber;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PrePopulatedData && this.equalTo((PrePopulatedData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PrePopulatedData other) {
        return this.buyerEmail.equals(other.buyerEmail) && this.buyerPhoneNumber.equals(other.buyerPhoneNumber) && this.buyerAddress.equals(other.buyerAddress);
    }

    public int hashCode() {
        return Objects.hash(this.buyerEmail, this.buyerPhoneNumber, this.buyerAddress);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> buyerEmail = Optional.empty();
        private Optional<String> buyerPhoneNumber = Optional.empty();
        private Optional<Address> buyerAddress = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PrePopulatedData other) {
            this.buyerEmail(other.getBuyerEmail());
            this.buyerPhoneNumber(other.getBuyerPhoneNumber());
            this.buyerAddress(other.getBuyerAddress());
            return this;
        }

        @JsonSetter(value="buyer_email", nulls=Nulls.SKIP)
        public Builder buyerEmail(Optional<String> buyerEmail) {
            this.buyerEmail = buyerEmail;
            return this;
        }

        public Builder buyerEmail(String buyerEmail) {
            this.buyerEmail = Optional.ofNullable(buyerEmail);
            return this;
        }

        public Builder buyerEmail(Nullable<String> buyerEmail) {
            this.buyerEmail = buyerEmail.isNull() ? null : (buyerEmail.isEmpty() ? Optional.empty() : Optional.of(buyerEmail.get()));
            return this;
        }

        @JsonSetter(value="buyer_phone_number", nulls=Nulls.SKIP)
        public Builder buyerPhoneNumber(Optional<String> buyerPhoneNumber) {
            this.buyerPhoneNumber = buyerPhoneNumber;
            return this;
        }

        public Builder buyerPhoneNumber(String buyerPhoneNumber) {
            this.buyerPhoneNumber = Optional.ofNullable(buyerPhoneNumber);
            return this;
        }

        public Builder buyerPhoneNumber(Nullable<String> buyerPhoneNumber) {
            this.buyerPhoneNumber = buyerPhoneNumber.isNull() ? null : (buyerPhoneNumber.isEmpty() ? Optional.empty() : Optional.of(buyerPhoneNumber.get()));
            return this;
        }

        @JsonSetter(value="buyer_address", nulls=Nulls.SKIP)
        public Builder buyerAddress(Optional<Address> buyerAddress) {
            this.buyerAddress = buyerAddress;
            return this;
        }

        public Builder buyerAddress(Address buyerAddress) {
            this.buyerAddress = Optional.ofNullable(buyerAddress);
            return this;
        }

        public PrePopulatedData build() {
            return new PrePopulatedData(this.buyerEmail, this.buyerPhoneNumber, this.buyerAddress, this.additionalProperties);
        }
    }
}

