/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Payout;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PayoutPaidEventObject {
    private final Optional<Payout> payout;
    private final Map<String, Object> additionalProperties;

    private PayoutPaidEventObject(Optional<Payout> payout, Map<String, Object> additionalProperties) {
        this.payout = payout;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payout")
    public Optional<Payout> getPayout() {
        return this.payout;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PayoutPaidEventObject && this.equalTo((PayoutPaidEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PayoutPaidEventObject other) {
        return this.payout.equals(other.payout);
    }

    public int hashCode() {
        return Objects.hash(this.payout);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Payout> payout = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PayoutPaidEventObject other) {
            this.payout(other.getPayout());
            return this;
        }

        @JsonSetter(value="payout", nulls=Nulls.SKIP)
        public Builder payout(Optional<Payout> payout) {
            this.payout = payout;
            return this;
        }

        public Builder payout(Payout payout) {
            this.payout = Optional.ofNullable(payout);
            return this;
        }

        public PayoutPaidEventObject build() {
            return new PayoutPaidEventObject(this.payout, this.additionalProperties);
        }
    }
}

