/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Destination;
import com.squareup.square.types.Money;
import com.squareup.square.types.PayoutFee;
import com.squareup.square.types.PayoutStatus;
import com.squareup.square.types.PayoutType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Payout {
    private final String id;
    private final Optional<PayoutStatus> status;
    private final String locationId;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<Money> amountMoney;
    private final Optional<Destination> destination;
    private final Optional<Integer> version;
    private final Optional<PayoutType> type;
    private final Optional<List<PayoutFee>> payoutFee;
    private final Optional<String> arrivalDate;
    private final Optional<String> endToEndId;
    private final Map<String, Object> additionalProperties;

    private Payout(String id, Optional<PayoutStatus> status, String locationId, Optional<String> createdAt, Optional<String> updatedAt, Optional<Money> amountMoney, Optional<Destination> destination, Optional<Integer> version, Optional<PayoutType> type, Optional<List<PayoutFee>> payoutFee, Optional<String> arrivalDate, Optional<String> endToEndId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.status = status;
        this.locationId = locationId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.amountMoney = amountMoney;
        this.destination = destination;
        this.version = version;
        this.type = type;
        this.payoutFee = payoutFee;
        this.arrivalDate = arrivalDate;
        this.endToEndId = endToEndId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public Optional<PayoutStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="destination")
    public Optional<Destination> getDestination() {
        return this.destination;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="type")
    public Optional<PayoutType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<List<PayoutFee>> getPayoutFee() {
        if (this.payoutFee == null) {
            return Optional.empty();
        }
        return this.payoutFee;
    }

    @JsonIgnore
    public Optional<String> getArrivalDate() {
        if (this.arrivalDate == null) {
            return Optional.empty();
        }
        return this.arrivalDate;
    }

    @JsonIgnore
    public Optional<String> getEndToEndId() {
        if (this.endToEndId == null) {
            return Optional.empty();
        }
        return this.endToEndId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payout_fee")
    private Optional<List<PayoutFee>> _getPayoutFee() {
        return this.payoutFee;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="arrival_date")
    private Optional<String> _getArrivalDate() {
        return this.arrivalDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_to_end_id")
    private Optional<String> _getEndToEndId() {
        return this.endToEndId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Payout && this.equalTo((Payout)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Payout other) {
        return this.id.equals(other.id) && this.status.equals(other.status) && this.locationId.equals(other.locationId) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.amountMoney.equals(other.amountMoney) && this.destination.equals(other.destination) && this.version.equals(other.version) && this.type.equals(other.type) && this.payoutFee.equals(other.payoutFee) && this.arrivalDate.equals(other.arrivalDate) && this.endToEndId.equals(other.endToEndId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.locationId, this.createdAt, this.updatedAt, this.amountMoney, this.destination, this.version, this.type, this.payoutFee, this.arrivalDate, this.endToEndId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    LocationIdStage,
    _FinalStage {
        private String id;
        private String locationId;
        private Optional<String> endToEndId = Optional.empty();
        private Optional<String> arrivalDate = Optional.empty();
        private Optional<List<PayoutFee>> payoutFee = Optional.empty();
        private Optional<PayoutType> type = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<Destination> destination = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<PayoutStatus> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Payout other) {
            this.id(other.getId());
            this.status(other.getStatus());
            this.locationId(other.getLocationId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.amountMoney(other.getAmountMoney());
            this.destination(other.getDestination());
            this.version(other.getVersion());
            this.type(other.getType());
            this.payoutFee(other.getPayoutFee());
            this.arrivalDate(other.getArrivalDate());
            this.endToEndId(other.getEndToEndId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public LocationIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public _FinalStage endToEndId(Nullable<String> endToEndId) {
            this.endToEndId = endToEndId.isNull() ? null : (endToEndId.isEmpty() ? Optional.empty() : Optional.of(endToEndId.get()));
            return this;
        }

        @Override
        public _FinalStage endToEndId(String endToEndId) {
            this.endToEndId = Optional.ofNullable(endToEndId);
            return this;
        }

        @Override
        @JsonSetter(value="end_to_end_id", nulls=Nulls.SKIP)
        public _FinalStage endToEndId(Optional<String> endToEndId) {
            this.endToEndId = endToEndId;
            return this;
        }

        @Override
        public _FinalStage arrivalDate(Nullable<String> arrivalDate) {
            this.arrivalDate = arrivalDate.isNull() ? null : (arrivalDate.isEmpty() ? Optional.empty() : Optional.of(arrivalDate.get()));
            return this;
        }

        @Override
        public _FinalStage arrivalDate(String arrivalDate) {
            this.arrivalDate = Optional.ofNullable(arrivalDate);
            return this;
        }

        @Override
        @JsonSetter(value="arrival_date", nulls=Nulls.SKIP)
        public _FinalStage arrivalDate(Optional<String> arrivalDate) {
            this.arrivalDate = arrivalDate;
            return this;
        }

        @Override
        public _FinalStage payoutFee(Nullable<List<PayoutFee>> payoutFee) {
            this.payoutFee = payoutFee.isNull() ? null : (payoutFee.isEmpty() ? Optional.empty() : Optional.of(payoutFee.get()));
            return this;
        }

        @Override
        public _FinalStage payoutFee(List<PayoutFee> payoutFee) {
            this.payoutFee = Optional.ofNullable(payoutFee);
            return this;
        }

        @Override
        @JsonSetter(value="payout_fee", nulls=Nulls.SKIP)
        public _FinalStage payoutFee(Optional<List<PayoutFee>> payoutFee) {
            this.payoutFee = payoutFee;
            return this;
        }

        @Override
        public _FinalStage type(PayoutType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<PayoutType> type) {
            this.type = type;
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage destination(Destination destination) {
            this.destination = Optional.ofNullable(destination);
            return this;
        }

        @Override
        @JsonSetter(value="destination", nulls=Nulls.SKIP)
        public _FinalStage destination(Optional<Destination> destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public _FinalStage amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @Override
        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public _FinalStage amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage status(PayoutStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<PayoutStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public Payout build() {
            return new Payout(this.id, this.status, this.locationId, this.createdAt, this.updatedAt, this.amountMoney, this.destination, this.version, this.type, this.payoutFee, this.arrivalDate, this.endToEndId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Payout build();

        public _FinalStage status(Optional<PayoutStatus> var1);

        public _FinalStage status(PayoutStatus var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage amountMoney(Optional<Money> var1);

        public _FinalStage amountMoney(Money var1);

        public _FinalStage destination(Optional<Destination> var1);

        public _FinalStage destination(Destination var1);

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage type(Optional<PayoutType> var1);

        public _FinalStage type(PayoutType var1);

        public _FinalStage payoutFee(Optional<List<PayoutFee>> var1);

        public _FinalStage payoutFee(List<PayoutFee> var1);

        public _FinalStage payoutFee(Nullable<List<PayoutFee>> var1);

        public _FinalStage arrivalDate(Optional<String> var1);

        public _FinalStage arrivalDate(String var1);

        public _FinalStage arrivalDate(Nullable<String> var1);

        public _FinalStage endToEndId(Optional<String> var1);

        public _FinalStage endToEndId(String var1);

        public _FinalStage endToEndId(Nullable<String> var1);
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);
    }

    public static interface IdStage {
        public LocationIdStage id(@NotNull String var1);

        public Builder from(Payout var1);
    }
}

