/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.PaymentOptionsDelayAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentOptions {
    private final Optional<Boolean> autocomplete;
    private final Optional<String> delayDuration;
    private final Optional<Boolean> acceptPartialAuthorization;
    private final Optional<PaymentOptionsDelayAction> delayAction;
    private final Map<String, Object> additionalProperties;

    private PaymentOptions(Optional<Boolean> autocomplete, Optional<String> delayDuration, Optional<Boolean> acceptPartialAuthorization, Optional<PaymentOptionsDelayAction> delayAction, Map<String, Object> additionalProperties) {
        this.autocomplete = autocomplete;
        this.delayDuration = delayDuration;
        this.acceptPartialAuthorization = acceptPartialAuthorization;
        this.delayAction = delayAction;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Boolean> getAutocomplete() {
        if (this.autocomplete == null) {
            return Optional.empty();
        }
        return this.autocomplete;
    }

    @JsonIgnore
    public Optional<String> getDelayDuration() {
        if (this.delayDuration == null) {
            return Optional.empty();
        }
        return this.delayDuration;
    }

    @JsonIgnore
    public Optional<Boolean> getAcceptPartialAuthorization() {
        if (this.acceptPartialAuthorization == null) {
            return Optional.empty();
        }
        return this.acceptPartialAuthorization;
    }

    @JsonProperty(value="delay_action")
    public Optional<PaymentOptionsDelayAction> getDelayAction() {
        return this.delayAction;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="autocomplete")
    private Optional<Boolean> _getAutocomplete() {
        return this.autocomplete;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="delay_duration")
    private Optional<String> _getDelayDuration() {
        return this.delayDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="accept_partial_authorization")
    private Optional<Boolean> _getAcceptPartialAuthorization() {
        return this.acceptPartialAuthorization;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentOptions && this.equalTo((PaymentOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentOptions other) {
        return this.autocomplete.equals(other.autocomplete) && this.delayDuration.equals(other.delayDuration) && this.acceptPartialAuthorization.equals(other.acceptPartialAuthorization) && this.delayAction.equals(other.delayAction);
    }

    public int hashCode() {
        return Objects.hash(this.autocomplete, this.delayDuration, this.acceptPartialAuthorization, this.delayAction);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> autocomplete = Optional.empty();
        private Optional<String> delayDuration = Optional.empty();
        private Optional<Boolean> acceptPartialAuthorization = Optional.empty();
        private Optional<PaymentOptionsDelayAction> delayAction = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaymentOptions other) {
            this.autocomplete(other.getAutocomplete());
            this.delayDuration(other.getDelayDuration());
            this.acceptPartialAuthorization(other.getAcceptPartialAuthorization());
            this.delayAction(other.getDelayAction());
            return this;
        }

        @JsonSetter(value="autocomplete", nulls=Nulls.SKIP)
        public Builder autocomplete(Optional<Boolean> autocomplete) {
            this.autocomplete = autocomplete;
            return this;
        }

        public Builder autocomplete(Boolean autocomplete) {
            this.autocomplete = Optional.ofNullable(autocomplete);
            return this;
        }

        public Builder autocomplete(Nullable<Boolean> autocomplete) {
            this.autocomplete = autocomplete.isNull() ? null : (autocomplete.isEmpty() ? Optional.empty() : Optional.of(autocomplete.get()));
            return this;
        }

        @JsonSetter(value="delay_duration", nulls=Nulls.SKIP)
        public Builder delayDuration(Optional<String> delayDuration) {
            this.delayDuration = delayDuration;
            return this;
        }

        public Builder delayDuration(String delayDuration) {
            this.delayDuration = Optional.ofNullable(delayDuration);
            return this;
        }

        public Builder delayDuration(Nullable<String> delayDuration) {
            this.delayDuration = delayDuration.isNull() ? null : (delayDuration.isEmpty() ? Optional.empty() : Optional.of(delayDuration.get()));
            return this;
        }

        @JsonSetter(value="accept_partial_authorization", nulls=Nulls.SKIP)
        public Builder acceptPartialAuthorization(Optional<Boolean> acceptPartialAuthorization) {
            this.acceptPartialAuthorization = acceptPartialAuthorization;
            return this;
        }

        public Builder acceptPartialAuthorization(Boolean acceptPartialAuthorization) {
            this.acceptPartialAuthorization = Optional.ofNullable(acceptPartialAuthorization);
            return this;
        }

        public Builder acceptPartialAuthorization(Nullable<Boolean> acceptPartialAuthorization) {
            this.acceptPartialAuthorization = acceptPartialAuthorization.isNull() ? null : (acceptPartialAuthorization.isEmpty() ? Optional.empty() : Optional.of(acceptPartialAuthorization.get()));
            return this;
        }

        @JsonSetter(value="delay_action", nulls=Nulls.SKIP)
        public Builder delayAction(Optional<PaymentOptionsDelayAction> delayAction) {
            this.delayAction = delayAction;
            return this;
        }

        public Builder delayAction(PaymentOptionsDelayAction delayAction) {
            this.delayAction = Optional.ofNullable(delayAction);
            return this;
        }

        public PaymentOptions build() {
            return new PaymentOptions(this.autocomplete, this.delayDuration, this.acceptPartialAuthorization, this.delayAction, this.additionalProperties);
        }
    }
}

