/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.Order;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentLinkRelatedResources {
    private final Optional<List<Order>> orders;
    private final Optional<List<CatalogObject>> subscriptionPlans;
    private final Map<String, Object> additionalProperties;

    private PaymentLinkRelatedResources(Optional<List<Order>> orders, Optional<List<CatalogObject>> subscriptionPlans, Map<String, Object> additionalProperties) {
        this.orders = orders;
        this.subscriptionPlans = subscriptionPlans;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Order>> getOrders() {
        if (this.orders == null) {
            return Optional.empty();
        }
        return this.orders;
    }

    @JsonIgnore
    public Optional<List<CatalogObject>> getSubscriptionPlans() {
        if (this.subscriptionPlans == null) {
            return Optional.empty();
        }
        return this.subscriptionPlans;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="orders")
    private Optional<List<Order>> _getOrders() {
        return this.orders;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="subscription_plans")
    private Optional<List<CatalogObject>> _getSubscriptionPlans() {
        return this.subscriptionPlans;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentLinkRelatedResources && this.equalTo((PaymentLinkRelatedResources)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentLinkRelatedResources other) {
        return this.orders.equals(other.orders) && this.subscriptionPlans.equals(other.subscriptionPlans);
    }

    public int hashCode() {
        return Objects.hash(this.orders, this.subscriptionPlans);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Order>> orders = Optional.empty();
        private Optional<List<CatalogObject>> subscriptionPlans = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaymentLinkRelatedResources other) {
            this.orders(other.getOrders());
            this.subscriptionPlans(other.getSubscriptionPlans());
            return this;
        }

        @JsonSetter(value="orders", nulls=Nulls.SKIP)
        public Builder orders(Optional<List<Order>> orders) {
            this.orders = orders;
            return this;
        }

        public Builder orders(List<Order> orders) {
            this.orders = Optional.ofNullable(orders);
            return this;
        }

        public Builder orders(Nullable<List<Order>> orders) {
            this.orders = orders.isNull() ? null : (orders.isEmpty() ? Optional.empty() : Optional.of(orders.get()));
            return this;
        }

        @JsonSetter(value="subscription_plans", nulls=Nulls.SKIP)
        public Builder subscriptionPlans(Optional<List<CatalogObject>> subscriptionPlans) {
            this.subscriptionPlans = subscriptionPlans;
            return this;
        }

        public Builder subscriptionPlans(List<CatalogObject> subscriptionPlans) {
            this.subscriptionPlans = Optional.ofNullable(subscriptionPlans);
            return this;
        }

        public Builder subscriptionPlans(Nullable<List<CatalogObject>> subscriptionPlans) {
            this.subscriptionPlans = subscriptionPlans.isNull() ? null : (subscriptionPlans.isEmpty() ? Optional.empty() : Optional.of(subscriptionPlans.get()));
            return this;
        }

        public PaymentLinkRelatedResources build() {
            return new PaymentLinkRelatedResources(this.orders, this.subscriptionPlans, this.additionalProperties);
        }
    }
}

