/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentBalanceActivityDepositFeeDetail {
    private final Optional<String> payoutId;
    private final Map<String, Object> additionalProperties;

    private PaymentBalanceActivityDepositFeeDetail(Optional<String> payoutId, Map<String, Object> additionalProperties) {
        this.payoutId = payoutId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getPayoutId() {
        if (this.payoutId == null) {
            return Optional.empty();
        }
        return this.payoutId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payout_id")
    private Optional<String> _getPayoutId() {
        return this.payoutId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentBalanceActivityDepositFeeDetail && this.equalTo((PaymentBalanceActivityDepositFeeDetail)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentBalanceActivityDepositFeeDetail other) {
        return this.payoutId.equals(other.payoutId);
    }

    public int hashCode() {
        return Objects.hash(this.payoutId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> payoutId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaymentBalanceActivityDepositFeeDetail other) {
            this.payoutId(other.getPayoutId());
            return this;
        }

        @JsonSetter(value="payout_id", nulls=Nulls.SKIP)
        public Builder payoutId(Optional<String> payoutId) {
            this.payoutId = payoutId;
            return this;
        }

        public Builder payoutId(String payoutId) {
            this.payoutId = Optional.ofNullable(payoutId);
            return this;
        }

        public Builder payoutId(Nullable<String> payoutId) {
            this.payoutId = payoutId.isNull() ? null : (payoutId.isEmpty() ? Optional.empty() : Optional.of(payoutId.get()));
            return this;
        }

        public PaymentBalanceActivityDepositFeeDetail build() {
            return new PaymentBalanceActivityDepositFeeDetail(this.payoutId, this.additionalProperties);
        }
    }
}

