/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentBalanceActivityAppFeeRefundDetail {
    private final Optional<String> paymentId;
    private final Optional<String> refundId;
    private final Optional<String> locationId;
    private final Map<String, Object> additionalProperties;

    private PaymentBalanceActivityAppFeeRefundDetail(Optional<String> paymentId, Optional<String> refundId, Optional<String> locationId, Map<String, Object> additionalProperties) {
        this.paymentId = paymentId;
        this.refundId = refundId;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getPaymentId() {
        if (this.paymentId == null) {
            return Optional.empty();
        }
        return this.paymentId;
    }

    @JsonIgnore
    public Optional<String> getRefundId() {
        if (this.refundId == null) {
            return Optional.empty();
        }
        return this.refundId;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_id")
    private Optional<String> _getPaymentId() {
        return this.paymentId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="refund_id")
    private Optional<String> _getRefundId() {
        return this.refundId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentBalanceActivityAppFeeRefundDetail && this.equalTo((PaymentBalanceActivityAppFeeRefundDetail)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentBalanceActivityAppFeeRefundDetail other) {
        return this.paymentId.equals(other.paymentId) && this.refundId.equals(other.refundId) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.refundId, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> paymentId = Optional.empty();
        private Optional<String> refundId = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaymentBalanceActivityAppFeeRefundDetail other) {
            this.paymentId(other.getPaymentId());
            this.refundId(other.getRefundId());
            this.locationId(other.getLocationId());
            return this;
        }

        @JsonSetter(value="payment_id", nulls=Nulls.SKIP)
        public Builder paymentId(Optional<String> paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = Optional.ofNullable(paymentId);
            return this;
        }

        public Builder paymentId(Nullable<String> paymentId) {
            this.paymentId = paymentId.isNull() ? null : (paymentId.isEmpty() ? Optional.empty() : Optional.of(paymentId.get()));
            return this;
        }

        @JsonSetter(value="refund_id", nulls=Nulls.SKIP)
        public Builder refundId(Optional<String> refundId) {
            this.refundId = refundId;
            return this;
        }

        public Builder refundId(String refundId) {
            this.refundId = Optional.ofNullable(refundId);
            return this;
        }

        public Builder refundId(Nullable<String> refundId) {
            this.refundId = refundId.isNull() ? null : (refundId.isEmpty() ? Optional.empty() : Optional.of(refundId.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        public PaymentBalanceActivityAppFeeRefundDetail build() {
            return new PaymentBalanceActivityAppFeeRefundDetail(this.paymentId, this.refundId, this.locationId, this.additionalProperties);
        }
    }
}

