/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.ApplicationDetails;
import com.squareup.square.types.BankAccountPaymentDetails;
import com.squareup.square.types.BuyNowPayLaterDetails;
import com.squareup.square.types.CardPaymentDetails;
import com.squareup.square.types.CashPaymentDetails;
import com.squareup.square.types.DeviceDetails;
import com.squareup.square.types.DigitalWalletDetails;
import com.squareup.square.types.ExternalPaymentDetails;
import com.squareup.square.types.Money;
import com.squareup.square.types.OfflinePaymentDetails;
import com.squareup.square.types.ProcessingFee;
import com.squareup.square.types.RiskEvaluation;
import com.squareup.square.types.SquareAccountDetails;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Payment {
    private final Optional<String> id;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<Money> amountMoney;
    private final Optional<Money> tipMoney;
    private final Optional<Money> totalMoney;
    private final Optional<Money> appFeeMoney;
    private final Optional<Money> approvedMoney;
    private final Optional<List<ProcessingFee>> processingFee;
    private final Optional<Money> refundedMoney;
    private final Optional<String> status;
    private final Optional<String> delayDuration;
    private final Optional<String> delayAction;
    private final Optional<String> delayedUntil;
    private final Optional<String> sourceType;
    private final Optional<CardPaymentDetails> cardDetails;
    private final Optional<CashPaymentDetails> cashDetails;
    private final Optional<BankAccountPaymentDetails> bankAccountDetails;
    private final Optional<ExternalPaymentDetails> externalDetails;
    private final Optional<DigitalWalletDetails> walletDetails;
    private final Optional<BuyNowPayLaterDetails> buyNowPayLaterDetails;
    private final Optional<SquareAccountDetails> squareAccountDetails;
    private final Optional<String> locationId;
    private final Optional<String> orderId;
    private final Optional<String> referenceId;
    private final Optional<String> customerId;
    private final Optional<String> employeeId;
    private final Optional<String> teamMemberId;
    private final Optional<List<String>> refundIds;
    private final Optional<RiskEvaluation> riskEvaluation;
    private final Optional<String> terminalCheckoutId;
    private final Optional<String> buyerEmailAddress;
    private final Optional<Address> billingAddress;
    private final Optional<Address> shippingAddress;
    private final Optional<String> note;
    private final Optional<String> statementDescriptionIdentifier;
    private final Optional<List<String>> capabilities;
    private final Optional<String> receiptNumber;
    private final Optional<String> receiptUrl;
    private final Optional<DeviceDetails> deviceDetails;
    private final Optional<ApplicationDetails> applicationDetails;
    private final Optional<Boolean> isOfflinePayment;
    private final Optional<OfflinePaymentDetails> offlinePaymentDetails;
    private final Optional<String> versionToken;
    private final Map<String, Object> additionalProperties;

    private Payment(Optional<String> id, Optional<String> createdAt, Optional<String> updatedAt, Optional<Money> amountMoney, Optional<Money> tipMoney, Optional<Money> totalMoney, Optional<Money> appFeeMoney, Optional<Money> approvedMoney, Optional<List<ProcessingFee>> processingFee, Optional<Money> refundedMoney, Optional<String> status, Optional<String> delayDuration, Optional<String> delayAction, Optional<String> delayedUntil, Optional<String> sourceType, Optional<CardPaymentDetails> cardDetails, Optional<CashPaymentDetails> cashDetails, Optional<BankAccountPaymentDetails> bankAccountDetails, Optional<ExternalPaymentDetails> externalDetails, Optional<DigitalWalletDetails> walletDetails, Optional<BuyNowPayLaterDetails> buyNowPayLaterDetails, Optional<SquareAccountDetails> squareAccountDetails, Optional<String> locationId, Optional<String> orderId, Optional<String> referenceId, Optional<String> customerId, Optional<String> employeeId, Optional<String> teamMemberId, Optional<List<String>> refundIds, Optional<RiskEvaluation> riskEvaluation, Optional<String> terminalCheckoutId, Optional<String> buyerEmailAddress, Optional<Address> billingAddress, Optional<Address> shippingAddress, Optional<String> note, Optional<String> statementDescriptionIdentifier, Optional<List<String>> capabilities, Optional<String> receiptNumber, Optional<String> receiptUrl, Optional<DeviceDetails> deviceDetails, Optional<ApplicationDetails> applicationDetails, Optional<Boolean> isOfflinePayment, Optional<OfflinePaymentDetails> offlinePaymentDetails, Optional<String> versionToken, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.amountMoney = amountMoney;
        this.tipMoney = tipMoney;
        this.totalMoney = totalMoney;
        this.appFeeMoney = appFeeMoney;
        this.approvedMoney = approvedMoney;
        this.processingFee = processingFee;
        this.refundedMoney = refundedMoney;
        this.status = status;
        this.delayDuration = delayDuration;
        this.delayAction = delayAction;
        this.delayedUntil = delayedUntil;
        this.sourceType = sourceType;
        this.cardDetails = cardDetails;
        this.cashDetails = cashDetails;
        this.bankAccountDetails = bankAccountDetails;
        this.externalDetails = externalDetails;
        this.walletDetails = walletDetails;
        this.buyNowPayLaterDetails = buyNowPayLaterDetails;
        this.squareAccountDetails = squareAccountDetails;
        this.locationId = locationId;
        this.orderId = orderId;
        this.referenceId = referenceId;
        this.customerId = customerId;
        this.employeeId = employeeId;
        this.teamMemberId = teamMemberId;
        this.refundIds = refundIds;
        this.riskEvaluation = riskEvaluation;
        this.terminalCheckoutId = terminalCheckoutId;
        this.buyerEmailAddress = buyerEmailAddress;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.note = note;
        this.statementDescriptionIdentifier = statementDescriptionIdentifier;
        this.capabilities = capabilities;
        this.receiptNumber = receiptNumber;
        this.receiptUrl = receiptUrl;
        this.deviceDetails = deviceDetails;
        this.applicationDetails = applicationDetails;
        this.isOfflinePayment = isOfflinePayment;
        this.offlinePaymentDetails = offlinePaymentDetails;
        this.versionToken = versionToken;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="tip_money")
    public Optional<Money> getTipMoney() {
        return this.tipMoney;
    }

    @JsonProperty(value="total_money")
    public Optional<Money> getTotalMoney() {
        return this.totalMoney;
    }

    @JsonProperty(value="app_fee_money")
    public Optional<Money> getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonProperty(value="approved_money")
    public Optional<Money> getApprovedMoney() {
        return this.approvedMoney;
    }

    @JsonProperty(value="processing_fee")
    public Optional<List<ProcessingFee>> getProcessingFee() {
        return this.processingFee;
    }

    @JsonProperty(value="refunded_money")
    public Optional<Money> getRefundedMoney() {
        return this.refundedMoney;
    }

    @JsonProperty(value="status")
    public Optional<String> getStatus() {
        return this.status;
    }

    @JsonProperty(value="delay_duration")
    public Optional<String> getDelayDuration() {
        return this.delayDuration;
    }

    @JsonIgnore
    public Optional<String> getDelayAction() {
        if (this.delayAction == null) {
            return Optional.empty();
        }
        return this.delayAction;
    }

    @JsonProperty(value="delayed_until")
    public Optional<String> getDelayedUntil() {
        return this.delayedUntil;
    }

    @JsonProperty(value="source_type")
    public Optional<String> getSourceType() {
        return this.sourceType;
    }

    @JsonProperty(value="card_details")
    public Optional<CardPaymentDetails> getCardDetails() {
        return this.cardDetails;
    }

    @JsonProperty(value="cash_details")
    public Optional<CashPaymentDetails> getCashDetails() {
        return this.cashDetails;
    }

    @JsonProperty(value="bank_account_details")
    public Optional<BankAccountPaymentDetails> getBankAccountDetails() {
        return this.bankAccountDetails;
    }

    @JsonProperty(value="external_details")
    public Optional<ExternalPaymentDetails> getExternalDetails() {
        return this.externalDetails;
    }

    @JsonProperty(value="wallet_details")
    public Optional<DigitalWalletDetails> getWalletDetails() {
        return this.walletDetails;
    }

    @JsonProperty(value="buy_now_pay_later_details")
    public Optional<BuyNowPayLaterDetails> getBuyNowPayLaterDetails() {
        return this.buyNowPayLaterDetails;
    }

    @JsonProperty(value="square_account_details")
    public Optional<SquareAccountDetails> getSquareAccountDetails() {
        return this.squareAccountDetails;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="order_id")
    public Optional<String> getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="reference_id")
    public Optional<String> getReferenceId() {
        return this.referenceId;
    }

    @JsonProperty(value="customer_id")
    public Optional<String> getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="employee_id")
    public Optional<String> getEmployeeId() {
        return this.employeeId;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonProperty(value="refund_ids")
    public Optional<List<String>> getRefundIds() {
        return this.refundIds;
    }

    @JsonProperty(value="risk_evaluation")
    public Optional<RiskEvaluation> getRiskEvaluation() {
        return this.riskEvaluation;
    }

    @JsonProperty(value="terminal_checkout_id")
    public Optional<String> getTerminalCheckoutId() {
        return this.terminalCheckoutId;
    }

    @JsonProperty(value="buyer_email_address")
    public Optional<String> getBuyerEmailAddress() {
        return this.buyerEmailAddress;
    }

    @JsonProperty(value="billing_address")
    public Optional<Address> getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="shipping_address")
    public Optional<Address> getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonProperty(value="note")
    public Optional<String> getNote() {
        return this.note;
    }

    @JsonProperty(value="statement_description_identifier")
    public Optional<String> getStatementDescriptionIdentifier() {
        return this.statementDescriptionIdentifier;
    }

    @JsonProperty(value="capabilities")
    public Optional<List<String>> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="receipt_number")
    public Optional<String> getReceiptNumber() {
        return this.receiptNumber;
    }

    @JsonProperty(value="receipt_url")
    public Optional<String> getReceiptUrl() {
        return this.receiptUrl;
    }

    @JsonProperty(value="device_details")
    public Optional<DeviceDetails> getDeviceDetails() {
        return this.deviceDetails;
    }

    @JsonProperty(value="application_details")
    public Optional<ApplicationDetails> getApplicationDetails() {
        return this.applicationDetails;
    }

    @JsonProperty(value="is_offline_payment")
    public Optional<Boolean> getIsOfflinePayment() {
        return this.isOfflinePayment;
    }

    @JsonProperty(value="offline_payment_details")
    public Optional<OfflinePaymentDetails> getOfflinePaymentDetails() {
        return this.offlinePaymentDetails;
    }

    @JsonIgnore
    public Optional<String> getVersionToken() {
        if (this.versionToken == null) {
            return Optional.empty();
        }
        return this.versionToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="delay_action")
    private Optional<String> _getDelayAction() {
        return this.delayAction;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="version_token")
    private Optional<String> _getVersionToken() {
        return this.versionToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Payment && this.equalTo((Payment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Payment other) {
        return this.id.equals(other.id) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.amountMoney.equals(other.amountMoney) && this.tipMoney.equals(other.tipMoney) && this.totalMoney.equals(other.totalMoney) && this.appFeeMoney.equals(other.appFeeMoney) && this.approvedMoney.equals(other.approvedMoney) && this.processingFee.equals(other.processingFee) && this.refundedMoney.equals(other.refundedMoney) && this.status.equals(other.status) && this.delayDuration.equals(other.delayDuration) && this.delayAction.equals(other.delayAction) && this.delayedUntil.equals(other.delayedUntil) && this.sourceType.equals(other.sourceType) && this.cardDetails.equals(other.cardDetails) && this.cashDetails.equals(other.cashDetails) && this.bankAccountDetails.equals(other.bankAccountDetails) && this.externalDetails.equals(other.externalDetails) && this.walletDetails.equals(other.walletDetails) && this.buyNowPayLaterDetails.equals(other.buyNowPayLaterDetails) && this.squareAccountDetails.equals(other.squareAccountDetails) && this.locationId.equals(other.locationId) && this.orderId.equals(other.orderId) && this.referenceId.equals(other.referenceId) && this.customerId.equals(other.customerId) && this.employeeId.equals(other.employeeId) && this.teamMemberId.equals(other.teamMemberId) && this.refundIds.equals(other.refundIds) && this.riskEvaluation.equals(other.riskEvaluation) && this.terminalCheckoutId.equals(other.terminalCheckoutId) && this.buyerEmailAddress.equals(other.buyerEmailAddress) && this.billingAddress.equals(other.billingAddress) && this.shippingAddress.equals(other.shippingAddress) && this.note.equals(other.note) && this.statementDescriptionIdentifier.equals(other.statementDescriptionIdentifier) && this.capabilities.equals(other.capabilities) && this.receiptNumber.equals(other.receiptNumber) && this.receiptUrl.equals(other.receiptUrl) && this.deviceDetails.equals(other.deviceDetails) && this.applicationDetails.equals(other.applicationDetails) && this.isOfflinePayment.equals(other.isOfflinePayment) && this.offlinePaymentDetails.equals(other.offlinePaymentDetails) && this.versionToken.equals(other.versionToken);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.updatedAt, this.amountMoney, this.tipMoney, this.totalMoney, this.appFeeMoney, this.approvedMoney, this.processingFee, this.refundedMoney, this.status, this.delayDuration, this.delayAction, this.delayedUntil, this.sourceType, this.cardDetails, this.cashDetails, this.bankAccountDetails, this.externalDetails, this.walletDetails, this.buyNowPayLaterDetails, this.squareAccountDetails, this.locationId, this.orderId, this.referenceId, this.customerId, this.employeeId, this.teamMemberId, this.refundIds, this.riskEvaluation, this.terminalCheckoutId, this.buyerEmailAddress, this.billingAddress, this.shippingAddress, this.note, this.statementDescriptionIdentifier, this.capabilities, this.receiptNumber, this.receiptUrl, this.deviceDetails, this.applicationDetails, this.isOfflinePayment, this.offlinePaymentDetails, this.versionToken);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<Money> tipMoney = Optional.empty();
        private Optional<Money> totalMoney = Optional.empty();
        private Optional<Money> appFeeMoney = Optional.empty();
        private Optional<Money> approvedMoney = Optional.empty();
        private Optional<List<ProcessingFee>> processingFee = Optional.empty();
        private Optional<Money> refundedMoney = Optional.empty();
        private Optional<String> status = Optional.empty();
        private Optional<String> delayDuration = Optional.empty();
        private Optional<String> delayAction = Optional.empty();
        private Optional<String> delayedUntil = Optional.empty();
        private Optional<String> sourceType = Optional.empty();
        private Optional<CardPaymentDetails> cardDetails = Optional.empty();
        private Optional<CashPaymentDetails> cashDetails = Optional.empty();
        private Optional<BankAccountPaymentDetails> bankAccountDetails = Optional.empty();
        private Optional<ExternalPaymentDetails> externalDetails = Optional.empty();
        private Optional<DigitalWalletDetails> walletDetails = Optional.empty();
        private Optional<BuyNowPayLaterDetails> buyNowPayLaterDetails = Optional.empty();
        private Optional<SquareAccountDetails> squareAccountDetails = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<String> employeeId = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<List<String>> refundIds = Optional.empty();
        private Optional<RiskEvaluation> riskEvaluation = Optional.empty();
        private Optional<String> terminalCheckoutId = Optional.empty();
        private Optional<String> buyerEmailAddress = Optional.empty();
        private Optional<Address> billingAddress = Optional.empty();
        private Optional<Address> shippingAddress = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<String> statementDescriptionIdentifier = Optional.empty();
        private Optional<List<String>> capabilities = Optional.empty();
        private Optional<String> receiptNumber = Optional.empty();
        private Optional<String> receiptUrl = Optional.empty();
        private Optional<DeviceDetails> deviceDetails = Optional.empty();
        private Optional<ApplicationDetails> applicationDetails = Optional.empty();
        private Optional<Boolean> isOfflinePayment = Optional.empty();
        private Optional<OfflinePaymentDetails> offlinePaymentDetails = Optional.empty();
        private Optional<String> versionToken = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Payment other) {
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.amountMoney(other.getAmountMoney());
            this.tipMoney(other.getTipMoney());
            this.totalMoney(other.getTotalMoney());
            this.appFeeMoney(other.getAppFeeMoney());
            this.approvedMoney(other.getApprovedMoney());
            this.processingFee(other.getProcessingFee());
            this.refundedMoney(other.getRefundedMoney());
            this.status(other.getStatus());
            this.delayDuration(other.getDelayDuration());
            this.delayAction(other.getDelayAction());
            this.delayedUntil(other.getDelayedUntil());
            this.sourceType(other.getSourceType());
            this.cardDetails(other.getCardDetails());
            this.cashDetails(other.getCashDetails());
            this.bankAccountDetails(other.getBankAccountDetails());
            this.externalDetails(other.getExternalDetails());
            this.walletDetails(other.getWalletDetails());
            this.buyNowPayLaterDetails(other.getBuyNowPayLaterDetails());
            this.squareAccountDetails(other.getSquareAccountDetails());
            this.locationId(other.getLocationId());
            this.orderId(other.getOrderId());
            this.referenceId(other.getReferenceId());
            this.customerId(other.getCustomerId());
            this.employeeId(other.getEmployeeId());
            this.teamMemberId(other.getTeamMemberId());
            this.refundIds(other.getRefundIds());
            this.riskEvaluation(other.getRiskEvaluation());
            this.terminalCheckoutId(other.getTerminalCheckoutId());
            this.buyerEmailAddress(other.getBuyerEmailAddress());
            this.billingAddress(other.getBillingAddress());
            this.shippingAddress(other.getShippingAddress());
            this.note(other.getNote());
            this.statementDescriptionIdentifier(other.getStatementDescriptionIdentifier());
            this.capabilities(other.getCapabilities());
            this.receiptNumber(other.getReceiptNumber());
            this.receiptUrl(other.getReceiptUrl());
            this.deviceDetails(other.getDeviceDetails());
            this.applicationDetails(other.getApplicationDetails());
            this.isOfflinePayment(other.getIsOfflinePayment());
            this.offlinePaymentDetails(other.getOfflinePaymentDetails());
            this.versionToken(other.getVersionToken());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public Builder amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @JsonSetter(value="tip_money", nulls=Nulls.SKIP)
        public Builder tipMoney(Optional<Money> tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        public Builder tipMoney(Money tipMoney) {
            this.tipMoney = Optional.ofNullable(tipMoney);
            return this;
        }

        @JsonSetter(value="total_money", nulls=Nulls.SKIP)
        public Builder totalMoney(Optional<Money> totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = Optional.ofNullable(totalMoney);
            return this;
        }

        @JsonSetter(value="app_fee_money", nulls=Nulls.SKIP)
        public Builder appFeeMoney(Optional<Money> appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = Optional.ofNullable(appFeeMoney);
            return this;
        }

        @JsonSetter(value="approved_money", nulls=Nulls.SKIP)
        public Builder approvedMoney(Optional<Money> approvedMoney) {
            this.approvedMoney = approvedMoney;
            return this;
        }

        public Builder approvedMoney(Money approvedMoney) {
            this.approvedMoney = Optional.ofNullable(approvedMoney);
            return this;
        }

        @JsonSetter(value="processing_fee", nulls=Nulls.SKIP)
        public Builder processingFee(Optional<List<ProcessingFee>> processingFee) {
            this.processingFee = processingFee;
            return this;
        }

        public Builder processingFee(List<ProcessingFee> processingFee) {
            this.processingFee = Optional.ofNullable(processingFee);
            return this;
        }

        @JsonSetter(value="refunded_money", nulls=Nulls.SKIP)
        public Builder refundedMoney(Optional<Money> refundedMoney) {
            this.refundedMoney = refundedMoney;
            return this;
        }

        public Builder refundedMoney(Money refundedMoney) {
            this.refundedMoney = Optional.ofNullable(refundedMoney);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="delay_duration", nulls=Nulls.SKIP)
        public Builder delayDuration(Optional<String> delayDuration) {
            this.delayDuration = delayDuration;
            return this;
        }

        public Builder delayDuration(String delayDuration) {
            this.delayDuration = Optional.ofNullable(delayDuration);
            return this;
        }

        @JsonSetter(value="delay_action", nulls=Nulls.SKIP)
        public Builder delayAction(Optional<String> delayAction) {
            this.delayAction = delayAction;
            return this;
        }

        public Builder delayAction(String delayAction) {
            this.delayAction = Optional.ofNullable(delayAction);
            return this;
        }

        public Builder delayAction(Nullable<String> delayAction) {
            this.delayAction = delayAction.isNull() ? null : (delayAction.isEmpty() ? Optional.empty() : Optional.of(delayAction.get()));
            return this;
        }

        @JsonSetter(value="delayed_until", nulls=Nulls.SKIP)
        public Builder delayedUntil(Optional<String> delayedUntil) {
            this.delayedUntil = delayedUntil;
            return this;
        }

        public Builder delayedUntil(String delayedUntil) {
            this.delayedUntil = Optional.ofNullable(delayedUntil);
            return this;
        }

        @JsonSetter(value="source_type", nulls=Nulls.SKIP)
        public Builder sourceType(Optional<String> sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = Optional.ofNullable(sourceType);
            return this;
        }

        @JsonSetter(value="card_details", nulls=Nulls.SKIP)
        public Builder cardDetails(Optional<CardPaymentDetails> cardDetails) {
            this.cardDetails = cardDetails;
            return this;
        }

        public Builder cardDetails(CardPaymentDetails cardDetails) {
            this.cardDetails = Optional.ofNullable(cardDetails);
            return this;
        }

        @JsonSetter(value="cash_details", nulls=Nulls.SKIP)
        public Builder cashDetails(Optional<CashPaymentDetails> cashDetails) {
            this.cashDetails = cashDetails;
            return this;
        }

        public Builder cashDetails(CashPaymentDetails cashDetails) {
            this.cashDetails = Optional.ofNullable(cashDetails);
            return this;
        }

        @JsonSetter(value="bank_account_details", nulls=Nulls.SKIP)
        public Builder bankAccountDetails(Optional<BankAccountPaymentDetails> bankAccountDetails) {
            this.bankAccountDetails = bankAccountDetails;
            return this;
        }

        public Builder bankAccountDetails(BankAccountPaymentDetails bankAccountDetails) {
            this.bankAccountDetails = Optional.ofNullable(bankAccountDetails);
            return this;
        }

        @JsonSetter(value="external_details", nulls=Nulls.SKIP)
        public Builder externalDetails(Optional<ExternalPaymentDetails> externalDetails) {
            this.externalDetails = externalDetails;
            return this;
        }

        public Builder externalDetails(ExternalPaymentDetails externalDetails) {
            this.externalDetails = Optional.ofNullable(externalDetails);
            return this;
        }

        @JsonSetter(value="wallet_details", nulls=Nulls.SKIP)
        public Builder walletDetails(Optional<DigitalWalletDetails> walletDetails) {
            this.walletDetails = walletDetails;
            return this;
        }

        public Builder walletDetails(DigitalWalletDetails walletDetails) {
            this.walletDetails = Optional.ofNullable(walletDetails);
            return this;
        }

        @JsonSetter(value="buy_now_pay_later_details", nulls=Nulls.SKIP)
        public Builder buyNowPayLaterDetails(Optional<BuyNowPayLaterDetails> buyNowPayLaterDetails) {
            this.buyNowPayLaterDetails = buyNowPayLaterDetails;
            return this;
        }

        public Builder buyNowPayLaterDetails(BuyNowPayLaterDetails buyNowPayLaterDetails) {
            this.buyNowPayLaterDetails = Optional.ofNullable(buyNowPayLaterDetails);
            return this;
        }

        @JsonSetter(value="square_account_details", nulls=Nulls.SKIP)
        public Builder squareAccountDetails(Optional<SquareAccountDetails> squareAccountDetails) {
            this.squareAccountDetails = squareAccountDetails;
            return this;
        }

        public Builder squareAccountDetails(SquareAccountDetails squareAccountDetails) {
            this.squareAccountDetails = Optional.ofNullable(squareAccountDetails);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public Builder orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        @JsonSetter(value="employee_id", nulls=Nulls.SKIP)
        public Builder employeeId(Optional<String> employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = Optional.ofNullable(employeeId);
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        public Builder teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @JsonSetter(value="refund_ids", nulls=Nulls.SKIP)
        public Builder refundIds(Optional<List<String>> refundIds) {
            this.refundIds = refundIds;
            return this;
        }

        public Builder refundIds(List<String> refundIds) {
            this.refundIds = Optional.ofNullable(refundIds);
            return this;
        }

        @JsonSetter(value="risk_evaluation", nulls=Nulls.SKIP)
        public Builder riskEvaluation(Optional<RiskEvaluation> riskEvaluation) {
            this.riskEvaluation = riskEvaluation;
            return this;
        }

        public Builder riskEvaluation(RiskEvaluation riskEvaluation) {
            this.riskEvaluation = Optional.ofNullable(riskEvaluation);
            return this;
        }

        @JsonSetter(value="terminal_checkout_id", nulls=Nulls.SKIP)
        public Builder terminalCheckoutId(Optional<String> terminalCheckoutId) {
            this.terminalCheckoutId = terminalCheckoutId;
            return this;
        }

        public Builder terminalCheckoutId(String terminalCheckoutId) {
            this.terminalCheckoutId = Optional.ofNullable(terminalCheckoutId);
            return this;
        }

        @JsonSetter(value="buyer_email_address", nulls=Nulls.SKIP)
        public Builder buyerEmailAddress(Optional<String> buyerEmailAddress) {
            this.buyerEmailAddress = buyerEmailAddress;
            return this;
        }

        public Builder buyerEmailAddress(String buyerEmailAddress) {
            this.buyerEmailAddress = Optional.ofNullable(buyerEmailAddress);
            return this;
        }

        @JsonSetter(value="billing_address", nulls=Nulls.SKIP)
        public Builder billingAddress(Optional<Address> billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = Optional.ofNullable(billingAddress);
            return this;
        }

        @JsonSetter(value="shipping_address", nulls=Nulls.SKIP)
        public Builder shippingAddress(Optional<Address> shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = Optional.ofNullable(shippingAddress);
            return this;
        }

        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public Builder note(Optional<String> note) {
            this.note = note;
            return this;
        }

        public Builder note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @JsonSetter(value="statement_description_identifier", nulls=Nulls.SKIP)
        public Builder statementDescriptionIdentifier(Optional<String> statementDescriptionIdentifier) {
            this.statementDescriptionIdentifier = statementDescriptionIdentifier;
            return this;
        }

        public Builder statementDescriptionIdentifier(String statementDescriptionIdentifier) {
            this.statementDescriptionIdentifier = Optional.ofNullable(statementDescriptionIdentifier);
            return this;
        }

        @JsonSetter(value="capabilities", nulls=Nulls.SKIP)
        public Builder capabilities(Optional<List<String>> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder capabilities(List<String> capabilities) {
            this.capabilities = Optional.ofNullable(capabilities);
            return this;
        }

        @JsonSetter(value="receipt_number", nulls=Nulls.SKIP)
        public Builder receiptNumber(Optional<String> receiptNumber) {
            this.receiptNumber = receiptNumber;
            return this;
        }

        public Builder receiptNumber(String receiptNumber) {
            this.receiptNumber = Optional.ofNullable(receiptNumber);
            return this;
        }

        @JsonSetter(value="receipt_url", nulls=Nulls.SKIP)
        public Builder receiptUrl(Optional<String> receiptUrl) {
            this.receiptUrl = receiptUrl;
            return this;
        }

        public Builder receiptUrl(String receiptUrl) {
            this.receiptUrl = Optional.ofNullable(receiptUrl);
            return this;
        }

        @JsonSetter(value="device_details", nulls=Nulls.SKIP)
        public Builder deviceDetails(Optional<DeviceDetails> deviceDetails) {
            this.deviceDetails = deviceDetails;
            return this;
        }

        public Builder deviceDetails(DeviceDetails deviceDetails) {
            this.deviceDetails = Optional.ofNullable(deviceDetails);
            return this;
        }

        @JsonSetter(value="application_details", nulls=Nulls.SKIP)
        public Builder applicationDetails(Optional<ApplicationDetails> applicationDetails) {
            this.applicationDetails = applicationDetails;
            return this;
        }

        public Builder applicationDetails(ApplicationDetails applicationDetails) {
            this.applicationDetails = Optional.ofNullable(applicationDetails);
            return this;
        }

        @JsonSetter(value="is_offline_payment", nulls=Nulls.SKIP)
        public Builder isOfflinePayment(Optional<Boolean> isOfflinePayment) {
            this.isOfflinePayment = isOfflinePayment;
            return this;
        }

        public Builder isOfflinePayment(Boolean isOfflinePayment) {
            this.isOfflinePayment = Optional.ofNullable(isOfflinePayment);
            return this;
        }

        @JsonSetter(value="offline_payment_details", nulls=Nulls.SKIP)
        public Builder offlinePaymentDetails(Optional<OfflinePaymentDetails> offlinePaymentDetails) {
            this.offlinePaymentDetails = offlinePaymentDetails;
            return this;
        }

        public Builder offlinePaymentDetails(OfflinePaymentDetails offlinePaymentDetails) {
            this.offlinePaymentDetails = Optional.ofNullable(offlinePaymentDetails);
            return this;
        }

        @JsonSetter(value="version_token", nulls=Nulls.SKIP)
        public Builder versionToken(Optional<String> versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        public Builder versionToken(String versionToken) {
            this.versionToken = Optional.ofNullable(versionToken);
            return this;
        }

        public Builder versionToken(Nullable<String> versionToken) {
            this.versionToken = versionToken.isNull() ? null : (versionToken.isEmpty() ? Optional.empty() : Optional.of(versionToken.get()));
            return this;
        }

        public Payment build() {
            return new Payment(this.id, this.createdAt, this.updatedAt, this.amountMoney, this.tipMoney, this.totalMoney, this.appFeeMoney, this.approvedMoney, this.processingFee, this.refundedMoney, this.status, this.delayDuration, this.delayAction, this.delayedUntil, this.sourceType, this.cardDetails, this.cashDetails, this.bankAccountDetails, this.externalDetails, this.walletDetails, this.buyNowPayLaterDetails, this.squareAccountDetails, this.locationId, this.orderId, this.referenceId, this.customerId, this.employeeId, this.teamMemberId, this.refundIds, this.riskEvaluation, this.terminalCheckoutId, this.buyerEmailAddress, this.billingAddress, this.shippingAddress, this.note, this.statementDescriptionIdentifier, this.capabilities, this.receiptNumber, this.receiptUrl, this.deviceDetails, this.applicationDetails, this.isOfflinePayment, this.offlinePaymentDetails, this.versionToken, this.additionalProperties);
        }
    }
}

