/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PayOrderRequest {
    private final String orderId;
    private final String idempotencyKey;
    private final Optional<Integer> orderVersion;
    private final Optional<List<String>> paymentIds;
    private final Map<String, Object> additionalProperties;

    private PayOrderRequest(String orderId, String idempotencyKey, Optional<Integer> orderVersion, Optional<List<String>> paymentIds, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.idempotencyKey = idempotencyKey;
        this.orderVersion = orderVersion;
        this.paymentIds = paymentIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public Optional<Integer> getOrderVersion() {
        if (this.orderVersion == null) {
            return Optional.empty();
        }
        return this.orderVersion;
    }

    @JsonIgnore
    public Optional<List<String>> getPaymentIds() {
        if (this.paymentIds == null) {
            return Optional.empty();
        }
        return this.paymentIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_version")
    private Optional<Integer> _getOrderVersion() {
        return this.orderVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_ids")
    private Optional<List<String>> _getPaymentIds() {
        return this.paymentIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PayOrderRequest && this.equalTo((PayOrderRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PayOrderRequest other) {
        return this.orderId.equals(other.orderId) && this.idempotencyKey.equals(other.idempotencyKey) && this.orderVersion.equals(other.orderVersion) && this.paymentIds.equals(other.paymentIds);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.idempotencyKey, this.orderVersion, this.paymentIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    IdempotencyKeyStage,
    _FinalStage {
        private String orderId;
        private String idempotencyKey;
        private Optional<List<String>> paymentIds = Optional.empty();
        private Optional<Integer> orderVersion = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PayOrderRequest other) {
            this.orderId(other.getOrderId());
            this.idempotencyKey(other.getIdempotencyKey());
            this.orderVersion(other.getOrderVersion());
            this.paymentIds(other.getPaymentIds());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public IdempotencyKeyStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public _FinalStage paymentIds(Nullable<List<String>> paymentIds) {
            this.paymentIds = paymentIds.isNull() ? null : (paymentIds.isEmpty() ? Optional.empty() : Optional.of(paymentIds.get()));
            return this;
        }

        @Override
        public _FinalStage paymentIds(List<String> paymentIds) {
            this.paymentIds = Optional.ofNullable(paymentIds);
            return this;
        }

        @Override
        @JsonSetter(value="payment_ids", nulls=Nulls.SKIP)
        public _FinalStage paymentIds(Optional<List<String>> paymentIds) {
            this.paymentIds = paymentIds;
            return this;
        }

        @Override
        public _FinalStage orderVersion(Nullable<Integer> orderVersion) {
            this.orderVersion = orderVersion.isNull() ? null : (orderVersion.isEmpty() ? Optional.empty() : Optional.of(orderVersion.get()));
            return this;
        }

        @Override
        public _FinalStage orderVersion(Integer orderVersion) {
            this.orderVersion = Optional.ofNullable(orderVersion);
            return this;
        }

        @Override
        @JsonSetter(value="order_version", nulls=Nulls.SKIP)
        public _FinalStage orderVersion(Optional<Integer> orderVersion) {
            this.orderVersion = orderVersion;
            return this;
        }

        @Override
        public PayOrderRequest build() {
            return new PayOrderRequest(this.orderId, this.idempotencyKey, this.orderVersion, this.paymentIds, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PayOrderRequest build();

        public _FinalStage orderVersion(Optional<Integer> var1);

        public _FinalStage orderVersion(Integer var1);

        public _FinalStage orderVersion(Nullable<Integer> var1);

        public _FinalStage paymentIds(Optional<List<String>> var1);

        public _FinalStage paymentIds(List<String> var1);

        public _FinalStage paymentIds(Nullable<List<String>> var1);
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public IdempotencyKeyStage orderId(@NotNull String var1);

        public Builder from(PayOrderRequest var1);
    }
}

