/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class OrderState {
    public static final OrderState CANCELED = new OrderState(Value.CANCELED, "CANCELED");
    public static final OrderState DRAFT = new OrderState(Value.DRAFT, "DRAFT");
    public static final OrderState OPEN = new OrderState(Value.OPEN, "OPEN");
    public static final OrderState COMPLETED = new OrderState(Value.COMPLETED, "COMPLETED");
    private final Value value;
    private final String string;

    OrderState(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof OrderState && this.string.equals(((OrderState)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CANCELED: {
                return visitor.visitCanceled();
            }
            case DRAFT: {
                return visitor.visitDraft();
            }
            case OPEN: {
                return visitor.visitOpen();
            }
            case COMPLETED: {
                return visitor.visitCompleted();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static OrderState valueOf(String value) {
        switch (value) {
            case "CANCELED": {
                return CANCELED;
            }
            case "DRAFT": {
                return DRAFT;
            }
            case "OPEN": {
                return OPEN;
            }
            case "COMPLETED": {
                return COMPLETED;
            }
        }
        return new OrderState(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitOpen();

        public T visitCompleted();

        public T visitCanceled();

        public T visitDraft();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        OPEN,
        COMPLETED,
        CANCELED,
        DRAFT,
        UNKNOWN;

    }
}

