/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import com.squareup.square.types.OrderLineItemAppliedTax;
import com.squareup.square.types.OrderServiceChargeCalculationPhase;
import com.squareup.square.types.OrderServiceChargeScope;
import com.squareup.square.types.OrderServiceChargeTreatmentType;
import com.squareup.square.types.OrderServiceChargeType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderServiceCharge {
    private final Optional<String> uid;
    private final Optional<String> name;
    private final Optional<String> catalogObjectId;
    private final Optional<Long> catalogVersion;
    private final Optional<String> percentage;
    private final Optional<Money> amountMoney;
    private final Optional<Money> appliedMoney;
    private final Optional<Money> totalMoney;
    private final Optional<Money> totalTaxMoney;
    private final Optional<OrderServiceChargeCalculationPhase> calculationPhase;
    private final Optional<Boolean> taxable;
    private final Optional<List<OrderLineItemAppliedTax>> appliedTaxes;
    private final Optional<Map<String, Optional<String>>> metadata;
    private final Optional<OrderServiceChargeType> type;
    private final Optional<OrderServiceChargeTreatmentType> treatmentType;
    private final Optional<OrderServiceChargeScope> scope;
    private final Map<String, Object> additionalProperties;

    private OrderServiceCharge(Optional<String> uid, Optional<String> name, Optional<String> catalogObjectId, Optional<Long> catalogVersion, Optional<String> percentage, Optional<Money> amountMoney, Optional<Money> appliedMoney, Optional<Money> totalMoney, Optional<Money> totalTaxMoney, Optional<OrderServiceChargeCalculationPhase> calculationPhase, Optional<Boolean> taxable, Optional<List<OrderLineItemAppliedTax>> appliedTaxes, Optional<Map<String, Optional<String>>> metadata, Optional<OrderServiceChargeType> type, Optional<OrderServiceChargeTreatmentType> treatmentType, Optional<OrderServiceChargeScope> scope, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.name = name;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.percentage = percentage;
        this.amountMoney = amountMoney;
        this.appliedMoney = appliedMoney;
        this.totalMoney = totalMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.calculationPhase = calculationPhase;
        this.taxable = taxable;
        this.appliedTaxes = appliedTaxes;
        this.metadata = metadata;
        this.type = type;
        this.treatmentType = treatmentType;
        this.scope = scope;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectId() {
        if (this.catalogObjectId == null) {
            return Optional.empty();
        }
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<Long> getCatalogVersion() {
        if (this.catalogVersion == null) {
            return Optional.empty();
        }
        return this.catalogVersion;
    }

    @JsonIgnore
    public Optional<String> getPercentage() {
        if (this.percentage == null) {
            return Optional.empty();
        }
        return this.percentage;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="applied_money")
    public Optional<Money> getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonProperty(value="total_money")
    public Optional<Money> getTotalMoney() {
        return this.totalMoney;
    }

    @JsonProperty(value="total_tax_money")
    public Optional<Money> getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonProperty(value="calculation_phase")
    public Optional<OrderServiceChargeCalculationPhase> getCalculationPhase() {
        return this.calculationPhase;
    }

    @JsonIgnore
    public Optional<Boolean> getTaxable() {
        if (this.taxable == null) {
            return Optional.empty();
        }
        return this.taxable;
    }

    @JsonIgnore
    public Optional<List<OrderLineItemAppliedTax>> getAppliedTaxes() {
        if (this.appliedTaxes == null) {
            return Optional.empty();
        }
        return this.appliedTaxes;
    }

    @JsonIgnore
    public Optional<Map<String, Optional<String>>> getMetadata() {
        if (this.metadata == null) {
            return Optional.empty();
        }
        return this.metadata;
    }

    @JsonProperty(value="type")
    public Optional<OrderServiceChargeType> getType() {
        return this.type;
    }

    @JsonProperty(value="treatment_type")
    public Optional<OrderServiceChargeTreatmentType> getTreatmentType() {
        return this.treatmentType;
    }

    @JsonProperty(value="scope")
    public Optional<OrderServiceChargeScope> getScope() {
        return this.scope;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_id")
    private Optional<String> _getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_version")
    private Optional<Long> _getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="percentage")
    private Optional<String> _getPercentage() {
        return this.percentage;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="taxable")
    private Optional<Boolean> _getTaxable() {
        return this.taxable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="applied_taxes")
    private Optional<List<OrderLineItemAppliedTax>> _getAppliedTaxes() {
        return this.appliedTaxes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="metadata")
    private Optional<Map<String, Optional<String>>> _getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderServiceCharge && this.equalTo((OrderServiceCharge)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderServiceCharge other) {
        return this.uid.equals(other.uid) && this.name.equals(other.name) && this.catalogObjectId.equals(other.catalogObjectId) && this.catalogVersion.equals(other.catalogVersion) && this.percentage.equals(other.percentage) && this.amountMoney.equals(other.amountMoney) && this.appliedMoney.equals(other.appliedMoney) && this.totalMoney.equals(other.totalMoney) && this.totalTaxMoney.equals(other.totalTaxMoney) && this.calculationPhase.equals(other.calculationPhase) && this.taxable.equals(other.taxable) && this.appliedTaxes.equals(other.appliedTaxes) && this.metadata.equals(other.metadata) && this.type.equals(other.type) && this.treatmentType.equals(other.treatmentType) && this.scope.equals(other.scope);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.name, this.catalogObjectId, this.catalogVersion, this.percentage, this.amountMoney, this.appliedMoney, this.totalMoney, this.totalTaxMoney, this.calculationPhase, this.taxable, this.appliedTaxes, this.metadata, this.type, this.treatmentType, this.scope);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> catalogObjectId = Optional.empty();
        private Optional<Long> catalogVersion = Optional.empty();
        private Optional<String> percentage = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<Money> appliedMoney = Optional.empty();
        private Optional<Money> totalMoney = Optional.empty();
        private Optional<Money> totalTaxMoney = Optional.empty();
        private Optional<OrderServiceChargeCalculationPhase> calculationPhase = Optional.empty();
        private Optional<Boolean> taxable = Optional.empty();
        private Optional<List<OrderLineItemAppliedTax>> appliedTaxes = Optional.empty();
        private Optional<Map<String, Optional<String>>> metadata = Optional.empty();
        private Optional<OrderServiceChargeType> type = Optional.empty();
        private Optional<OrderServiceChargeTreatmentType> treatmentType = Optional.empty();
        private Optional<OrderServiceChargeScope> scope = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderServiceCharge other) {
            this.uid(other.getUid());
            this.name(other.getName());
            this.catalogObjectId(other.getCatalogObjectId());
            this.catalogVersion(other.getCatalogVersion());
            this.percentage(other.getPercentage());
            this.amountMoney(other.getAmountMoney());
            this.appliedMoney(other.getAppliedMoney());
            this.totalMoney(other.getTotalMoney());
            this.totalTaxMoney(other.getTotalTaxMoney());
            this.calculationPhase(other.getCalculationPhase());
            this.taxable(other.getTaxable());
            this.appliedTaxes(other.getAppliedTaxes());
            this.metadata(other.getMetadata());
            this.type(other.getType());
            this.treatmentType(other.getTreatmentType());
            this.scope(other.getScope());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_id", nulls=Nulls.SKIP)
        public Builder catalogObjectId(Optional<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = Optional.ofNullable(catalogObjectId);
            return this;
        }

        public Builder catalogObjectId(Nullable<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId.isNull() ? null : (catalogObjectId.isEmpty() ? Optional.empty() : Optional.of(catalogObjectId.get()));
            return this;
        }

        @JsonSetter(value="catalog_version", nulls=Nulls.SKIP)
        public Builder catalogVersion(Optional<Long> catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = Optional.ofNullable(catalogVersion);
            return this;
        }

        public Builder catalogVersion(Nullable<Long> catalogVersion) {
            this.catalogVersion = catalogVersion.isNull() ? null : (catalogVersion.isEmpty() ? Optional.empty() : Optional.of(catalogVersion.get()));
            return this;
        }

        @JsonSetter(value="percentage", nulls=Nulls.SKIP)
        public Builder percentage(Optional<String> percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = Optional.ofNullable(percentage);
            return this;
        }

        public Builder percentage(Nullable<String> percentage) {
            this.percentage = percentage.isNull() ? null : (percentage.isEmpty() ? Optional.empty() : Optional.of(percentage.get()));
            return this;
        }

        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public Builder amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @JsonSetter(value="applied_money", nulls=Nulls.SKIP)
        public Builder appliedMoney(Optional<Money> appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = Optional.ofNullable(appliedMoney);
            return this;
        }

        @JsonSetter(value="total_money", nulls=Nulls.SKIP)
        public Builder totalMoney(Optional<Money> totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = Optional.ofNullable(totalMoney);
            return this;
        }

        @JsonSetter(value="total_tax_money", nulls=Nulls.SKIP)
        public Builder totalTaxMoney(Optional<Money> totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = Optional.ofNullable(totalTaxMoney);
            return this;
        }

        @JsonSetter(value="calculation_phase", nulls=Nulls.SKIP)
        public Builder calculationPhase(Optional<OrderServiceChargeCalculationPhase> calculationPhase) {
            this.calculationPhase = calculationPhase;
            return this;
        }

        public Builder calculationPhase(OrderServiceChargeCalculationPhase calculationPhase) {
            this.calculationPhase = Optional.ofNullable(calculationPhase);
            return this;
        }

        @JsonSetter(value="taxable", nulls=Nulls.SKIP)
        public Builder taxable(Optional<Boolean> taxable) {
            this.taxable = taxable;
            return this;
        }

        public Builder taxable(Boolean taxable) {
            this.taxable = Optional.ofNullable(taxable);
            return this;
        }

        public Builder taxable(Nullable<Boolean> taxable) {
            this.taxable = taxable.isNull() ? null : (taxable.isEmpty() ? Optional.empty() : Optional.of(taxable.get()));
            return this;
        }

        @JsonSetter(value="applied_taxes", nulls=Nulls.SKIP)
        public Builder appliedTaxes(Optional<List<OrderLineItemAppliedTax>> appliedTaxes) {
            this.appliedTaxes = appliedTaxes;
            return this;
        }

        public Builder appliedTaxes(List<OrderLineItemAppliedTax> appliedTaxes) {
            this.appliedTaxes = Optional.ofNullable(appliedTaxes);
            return this;
        }

        public Builder appliedTaxes(Nullable<List<OrderLineItemAppliedTax>> appliedTaxes) {
            this.appliedTaxes = appliedTaxes.isNull() ? null : (appliedTaxes.isEmpty() ? Optional.empty() : Optional.of(appliedTaxes.get()));
            return this;
        }

        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public Builder metadata(Optional<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(Map<String, Optional<String>> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        public Builder metadata(Nullable<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata.isNull() ? null : (metadata.isEmpty() ? Optional.empty() : Optional.of(metadata.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<OrderServiceChargeType> type) {
            this.type = type;
            return this;
        }

        public Builder type(OrderServiceChargeType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="treatment_type", nulls=Nulls.SKIP)
        public Builder treatmentType(Optional<OrderServiceChargeTreatmentType> treatmentType) {
            this.treatmentType = treatmentType;
            return this;
        }

        public Builder treatmentType(OrderServiceChargeTreatmentType treatmentType) {
            this.treatmentType = Optional.ofNullable(treatmentType);
            return this;
        }

        @JsonSetter(value="scope", nulls=Nulls.SKIP)
        public Builder scope(Optional<OrderServiceChargeScope> scope) {
            this.scope = scope;
            return this;
        }

        public Builder scope(OrderServiceChargeScope scope) {
            this.scope = Optional.ofNullable(scope);
            return this;
        }

        public OrderServiceCharge build() {
            return new OrderServiceCharge(this.uid, this.name, this.catalogObjectId, this.catalogVersion, this.percentage, this.amountMoney, this.appliedMoney, this.totalMoney, this.totalTaxMoney, this.calculationPhase, this.taxable, this.appliedTaxes, this.metadata, this.type, this.treatmentType, this.scope, this.additionalProperties);
        }
    }
}

