/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import com.squareup.square.types.OrderLineItemAppliedDiscount;
import com.squareup.square.types.OrderLineItemAppliedServiceCharge;
import com.squareup.square.types.OrderLineItemAppliedTax;
import com.squareup.square.types.OrderLineItemItemType;
import com.squareup.square.types.OrderQuantityUnit;
import com.squareup.square.types.OrderReturnLineItemModifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderReturnLineItem {
    private final Optional<String> uid;
    private final Optional<String> sourceLineItemUid;
    private final Optional<String> name;
    private final String quantity;
    private final Optional<OrderQuantityUnit> quantityUnit;
    private final Optional<String> note;
    private final Optional<String> catalogObjectId;
    private final Optional<Long> catalogVersion;
    private final Optional<String> variationName;
    private final Optional<OrderLineItemItemType> itemType;
    private final Optional<List<OrderReturnLineItemModifier>> returnModifiers;
    private final Optional<List<OrderLineItemAppliedTax>> appliedTaxes;
    private final Optional<List<OrderLineItemAppliedDiscount>> appliedDiscounts;
    private final Optional<Money> basePriceMoney;
    private final Optional<Money> variationTotalPriceMoney;
    private final Optional<Money> grossReturnMoney;
    private final Optional<Money> totalTaxMoney;
    private final Optional<Money> totalDiscountMoney;
    private final Optional<Money> totalMoney;
    private final Optional<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges;
    private final Optional<Money> totalServiceChargeMoney;
    private final Map<String, Object> additionalProperties;

    private OrderReturnLineItem(Optional<String> uid, Optional<String> sourceLineItemUid, Optional<String> name, String quantity, Optional<OrderQuantityUnit> quantityUnit, Optional<String> note, Optional<String> catalogObjectId, Optional<Long> catalogVersion, Optional<String> variationName, Optional<OrderLineItemItemType> itemType, Optional<List<OrderReturnLineItemModifier>> returnModifiers, Optional<List<OrderLineItemAppliedTax>> appliedTaxes, Optional<List<OrderLineItemAppliedDiscount>> appliedDiscounts, Optional<Money> basePriceMoney, Optional<Money> variationTotalPriceMoney, Optional<Money> grossReturnMoney, Optional<Money> totalTaxMoney, Optional<Money> totalDiscountMoney, Optional<Money> totalMoney, Optional<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges, Optional<Money> totalServiceChargeMoney, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.sourceLineItemUid = sourceLineItemUid;
        this.name = name;
        this.quantity = quantity;
        this.quantityUnit = quantityUnit;
        this.note = note;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.variationName = variationName;
        this.itemType = itemType;
        this.returnModifiers = returnModifiers;
        this.appliedTaxes = appliedTaxes;
        this.appliedDiscounts = appliedDiscounts;
        this.basePriceMoney = basePriceMoney;
        this.variationTotalPriceMoney = variationTotalPriceMoney;
        this.grossReturnMoney = grossReturnMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalMoney = totalMoney;
        this.appliedServiceCharges = appliedServiceCharges;
        this.totalServiceChargeMoney = totalServiceChargeMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonIgnore
    public Optional<String> getSourceLineItemUid() {
        if (this.sourceLineItemUid == null) {
            return Optional.empty();
        }
        return this.sourceLineItemUid;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="quantity")
    public String getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity_unit")
    public Optional<OrderQuantityUnit> getQuantityUnit() {
        return this.quantityUnit;
    }

    @JsonIgnore
    public Optional<String> getNote() {
        if (this.note == null) {
            return Optional.empty();
        }
        return this.note;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectId() {
        if (this.catalogObjectId == null) {
            return Optional.empty();
        }
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<Long> getCatalogVersion() {
        if (this.catalogVersion == null) {
            return Optional.empty();
        }
        return this.catalogVersion;
    }

    @JsonIgnore
    public Optional<String> getVariationName() {
        if (this.variationName == null) {
            return Optional.empty();
        }
        return this.variationName;
    }

    @JsonProperty(value="item_type")
    public Optional<OrderLineItemItemType> getItemType() {
        return this.itemType;
    }

    @JsonIgnore
    public Optional<List<OrderReturnLineItemModifier>> getReturnModifiers() {
        if (this.returnModifiers == null) {
            return Optional.empty();
        }
        return this.returnModifiers;
    }

    @JsonIgnore
    public Optional<List<OrderLineItemAppliedTax>> getAppliedTaxes() {
        if (this.appliedTaxes == null) {
            return Optional.empty();
        }
        return this.appliedTaxes;
    }

    @JsonIgnore
    public Optional<List<OrderLineItemAppliedDiscount>> getAppliedDiscounts() {
        if (this.appliedDiscounts == null) {
            return Optional.empty();
        }
        return this.appliedDiscounts;
    }

    @JsonProperty(value="base_price_money")
    public Optional<Money> getBasePriceMoney() {
        return this.basePriceMoney;
    }

    @JsonProperty(value="variation_total_price_money")
    public Optional<Money> getVariationTotalPriceMoney() {
        return this.variationTotalPriceMoney;
    }

    @JsonProperty(value="gross_return_money")
    public Optional<Money> getGrossReturnMoney() {
        return this.grossReturnMoney;
    }

    @JsonProperty(value="total_tax_money")
    public Optional<Money> getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonProperty(value="total_discount_money")
    public Optional<Money> getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    @JsonProperty(value="total_money")
    public Optional<Money> getTotalMoney() {
        return this.totalMoney;
    }

    @JsonIgnore
    public Optional<List<OrderLineItemAppliedServiceCharge>> getAppliedServiceCharges() {
        if (this.appliedServiceCharges == null) {
            return Optional.empty();
        }
        return this.appliedServiceCharges;
    }

    @JsonProperty(value="total_service_charge_money")
    public Optional<Money> getTotalServiceChargeMoney() {
        return this.totalServiceChargeMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_line_item_uid")
    private Optional<String> _getSourceLineItemUid() {
        return this.sourceLineItemUid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="note")
    private Optional<String> _getNote() {
        return this.note;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_id")
    private Optional<String> _getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_version")
    private Optional<Long> _getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="variation_name")
    private Optional<String> _getVariationName() {
        return this.variationName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="return_modifiers")
    private Optional<List<OrderReturnLineItemModifier>> _getReturnModifiers() {
        return this.returnModifiers;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="applied_taxes")
    private Optional<List<OrderLineItemAppliedTax>> _getAppliedTaxes() {
        return this.appliedTaxes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="applied_discounts")
    private Optional<List<OrderLineItemAppliedDiscount>> _getAppliedDiscounts() {
        return this.appliedDiscounts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="applied_service_charges")
    private Optional<List<OrderLineItemAppliedServiceCharge>> _getAppliedServiceCharges() {
        return this.appliedServiceCharges;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderReturnLineItem && this.equalTo((OrderReturnLineItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderReturnLineItem other) {
        return this.uid.equals(other.uid) && this.sourceLineItemUid.equals(other.sourceLineItemUid) && this.name.equals(other.name) && this.quantity.equals(other.quantity) && this.quantityUnit.equals(other.quantityUnit) && this.note.equals(other.note) && this.catalogObjectId.equals(other.catalogObjectId) && this.catalogVersion.equals(other.catalogVersion) && this.variationName.equals(other.variationName) && this.itemType.equals(other.itemType) && this.returnModifiers.equals(other.returnModifiers) && this.appliedTaxes.equals(other.appliedTaxes) && this.appliedDiscounts.equals(other.appliedDiscounts) && this.basePriceMoney.equals(other.basePriceMoney) && this.variationTotalPriceMoney.equals(other.variationTotalPriceMoney) && this.grossReturnMoney.equals(other.grossReturnMoney) && this.totalTaxMoney.equals(other.totalTaxMoney) && this.totalDiscountMoney.equals(other.totalDiscountMoney) && this.totalMoney.equals(other.totalMoney) && this.appliedServiceCharges.equals(other.appliedServiceCharges) && this.totalServiceChargeMoney.equals(other.totalServiceChargeMoney);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceLineItemUid, this.name, this.quantity, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.returnModifiers, this.appliedTaxes, this.appliedDiscounts, this.basePriceMoney, this.variationTotalPriceMoney, this.grossReturnMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney, this.appliedServiceCharges, this.totalServiceChargeMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QuantityStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements QuantityStage,
    _FinalStage {
        private String quantity;
        private Optional<Money> totalServiceChargeMoney = Optional.empty();
        private Optional<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges = Optional.empty();
        private Optional<Money> totalMoney = Optional.empty();
        private Optional<Money> totalDiscountMoney = Optional.empty();
        private Optional<Money> totalTaxMoney = Optional.empty();
        private Optional<Money> grossReturnMoney = Optional.empty();
        private Optional<Money> variationTotalPriceMoney = Optional.empty();
        private Optional<Money> basePriceMoney = Optional.empty();
        private Optional<List<OrderLineItemAppliedDiscount>> appliedDiscounts = Optional.empty();
        private Optional<List<OrderLineItemAppliedTax>> appliedTaxes = Optional.empty();
        private Optional<List<OrderReturnLineItemModifier>> returnModifiers = Optional.empty();
        private Optional<OrderLineItemItemType> itemType = Optional.empty();
        private Optional<String> variationName = Optional.empty();
        private Optional<Long> catalogVersion = Optional.empty();
        private Optional<String> catalogObjectId = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<OrderQuantityUnit> quantityUnit = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> sourceLineItemUid = Optional.empty();
        private Optional<String> uid = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrderReturnLineItem other) {
            this.uid(other.getUid());
            this.sourceLineItemUid(other.getSourceLineItemUid());
            this.name(other.getName());
            this.quantity(other.getQuantity());
            this.quantityUnit(other.getQuantityUnit());
            this.note(other.getNote());
            this.catalogObjectId(other.getCatalogObjectId());
            this.catalogVersion(other.getCatalogVersion());
            this.variationName(other.getVariationName());
            this.itemType(other.getItemType());
            this.returnModifiers(other.getReturnModifiers());
            this.appliedTaxes(other.getAppliedTaxes());
            this.appliedDiscounts(other.getAppliedDiscounts());
            this.basePriceMoney(other.getBasePriceMoney());
            this.variationTotalPriceMoney(other.getVariationTotalPriceMoney());
            this.grossReturnMoney(other.getGrossReturnMoney());
            this.totalTaxMoney(other.getTotalTaxMoney());
            this.totalDiscountMoney(other.getTotalDiscountMoney());
            this.totalMoney(other.getTotalMoney());
            this.appliedServiceCharges(other.getAppliedServiceCharges());
            this.totalServiceChargeMoney(other.getTotalServiceChargeMoney());
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public _FinalStage quantity(@NotNull String quantity) {
            this.quantity = Objects.requireNonNull(quantity, "quantity must not be null");
            return this;
        }

        @Override
        public _FinalStage totalServiceChargeMoney(Money totalServiceChargeMoney) {
            this.totalServiceChargeMoney = Optional.ofNullable(totalServiceChargeMoney);
            return this;
        }

        @Override
        @JsonSetter(value="total_service_charge_money", nulls=Nulls.SKIP)
        public _FinalStage totalServiceChargeMoney(Optional<Money> totalServiceChargeMoney) {
            this.totalServiceChargeMoney = totalServiceChargeMoney;
            return this;
        }

        @Override
        public _FinalStage appliedServiceCharges(Nullable<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges) {
            this.appliedServiceCharges = appliedServiceCharges.isNull() ? null : (appliedServiceCharges.isEmpty() ? Optional.empty() : Optional.of(appliedServiceCharges.get()));
            return this;
        }

        @Override
        public _FinalStage appliedServiceCharges(List<OrderLineItemAppliedServiceCharge> appliedServiceCharges) {
            this.appliedServiceCharges = Optional.ofNullable(appliedServiceCharges);
            return this;
        }

        @Override
        @JsonSetter(value="applied_service_charges", nulls=Nulls.SKIP)
        public _FinalStage appliedServiceCharges(Optional<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges) {
            this.appliedServiceCharges = appliedServiceCharges;
            return this;
        }

        @Override
        public _FinalStage totalMoney(Money totalMoney) {
            this.totalMoney = Optional.ofNullable(totalMoney);
            return this;
        }

        @Override
        @JsonSetter(value="total_money", nulls=Nulls.SKIP)
        public _FinalStage totalMoney(Optional<Money> totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        @Override
        public _FinalStage totalDiscountMoney(Money totalDiscountMoney) {
            this.totalDiscountMoney = Optional.ofNullable(totalDiscountMoney);
            return this;
        }

        @Override
        @JsonSetter(value="total_discount_money", nulls=Nulls.SKIP)
        public _FinalStage totalDiscountMoney(Optional<Money> totalDiscountMoney) {
            this.totalDiscountMoney = totalDiscountMoney;
            return this;
        }

        @Override
        public _FinalStage totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = Optional.ofNullable(totalTaxMoney);
            return this;
        }

        @Override
        @JsonSetter(value="total_tax_money", nulls=Nulls.SKIP)
        public _FinalStage totalTaxMoney(Optional<Money> totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        @Override
        public _FinalStage grossReturnMoney(Money grossReturnMoney) {
            this.grossReturnMoney = Optional.ofNullable(grossReturnMoney);
            return this;
        }

        @Override
        @JsonSetter(value="gross_return_money", nulls=Nulls.SKIP)
        public _FinalStage grossReturnMoney(Optional<Money> grossReturnMoney) {
            this.grossReturnMoney = grossReturnMoney;
            return this;
        }

        @Override
        public _FinalStage variationTotalPriceMoney(Money variationTotalPriceMoney) {
            this.variationTotalPriceMoney = Optional.ofNullable(variationTotalPriceMoney);
            return this;
        }

        @Override
        @JsonSetter(value="variation_total_price_money", nulls=Nulls.SKIP)
        public _FinalStage variationTotalPriceMoney(Optional<Money> variationTotalPriceMoney) {
            this.variationTotalPriceMoney = variationTotalPriceMoney;
            return this;
        }

        @Override
        public _FinalStage basePriceMoney(Money basePriceMoney) {
            this.basePriceMoney = Optional.ofNullable(basePriceMoney);
            return this;
        }

        @Override
        @JsonSetter(value="base_price_money", nulls=Nulls.SKIP)
        public _FinalStage basePriceMoney(Optional<Money> basePriceMoney) {
            this.basePriceMoney = basePriceMoney;
            return this;
        }

        @Override
        public _FinalStage appliedDiscounts(Nullable<List<OrderLineItemAppliedDiscount>> appliedDiscounts) {
            this.appliedDiscounts = appliedDiscounts.isNull() ? null : (appliedDiscounts.isEmpty() ? Optional.empty() : Optional.of(appliedDiscounts.get()));
            return this;
        }

        @Override
        public _FinalStage appliedDiscounts(List<OrderLineItemAppliedDiscount> appliedDiscounts) {
            this.appliedDiscounts = Optional.ofNullable(appliedDiscounts);
            return this;
        }

        @Override
        @JsonSetter(value="applied_discounts", nulls=Nulls.SKIP)
        public _FinalStage appliedDiscounts(Optional<List<OrderLineItemAppliedDiscount>> appliedDiscounts) {
            this.appliedDiscounts = appliedDiscounts;
            return this;
        }

        @Override
        public _FinalStage appliedTaxes(Nullable<List<OrderLineItemAppliedTax>> appliedTaxes) {
            this.appliedTaxes = appliedTaxes.isNull() ? null : (appliedTaxes.isEmpty() ? Optional.empty() : Optional.of(appliedTaxes.get()));
            return this;
        }

        @Override
        public _FinalStage appliedTaxes(List<OrderLineItemAppliedTax> appliedTaxes) {
            this.appliedTaxes = Optional.ofNullable(appliedTaxes);
            return this;
        }

        @Override
        @JsonSetter(value="applied_taxes", nulls=Nulls.SKIP)
        public _FinalStage appliedTaxes(Optional<List<OrderLineItemAppliedTax>> appliedTaxes) {
            this.appliedTaxes = appliedTaxes;
            return this;
        }

        @Override
        public _FinalStage returnModifiers(Nullable<List<OrderReturnLineItemModifier>> returnModifiers) {
            this.returnModifiers = returnModifiers.isNull() ? null : (returnModifiers.isEmpty() ? Optional.empty() : Optional.of(returnModifiers.get()));
            return this;
        }

        @Override
        public _FinalStage returnModifiers(List<OrderReturnLineItemModifier> returnModifiers) {
            this.returnModifiers = Optional.ofNullable(returnModifiers);
            return this;
        }

        @Override
        @JsonSetter(value="return_modifiers", nulls=Nulls.SKIP)
        public _FinalStage returnModifiers(Optional<List<OrderReturnLineItemModifier>> returnModifiers) {
            this.returnModifiers = returnModifiers;
            return this;
        }

        @Override
        public _FinalStage itemType(OrderLineItemItemType itemType) {
            this.itemType = Optional.ofNullable(itemType);
            return this;
        }

        @Override
        @JsonSetter(value="item_type", nulls=Nulls.SKIP)
        public _FinalStage itemType(Optional<OrderLineItemItemType> itemType) {
            this.itemType = itemType;
            return this;
        }

        @Override
        public _FinalStage variationName(Nullable<String> variationName) {
            this.variationName = variationName.isNull() ? null : (variationName.isEmpty() ? Optional.empty() : Optional.of(variationName.get()));
            return this;
        }

        @Override
        public _FinalStage variationName(String variationName) {
            this.variationName = Optional.ofNullable(variationName);
            return this;
        }

        @Override
        @JsonSetter(value="variation_name", nulls=Nulls.SKIP)
        public _FinalStage variationName(Optional<String> variationName) {
            this.variationName = variationName;
            return this;
        }

        @Override
        public _FinalStage catalogVersion(Nullable<Long> catalogVersion) {
            this.catalogVersion = catalogVersion.isNull() ? null : (catalogVersion.isEmpty() ? Optional.empty() : Optional.of(catalogVersion.get()));
            return this;
        }

        @Override
        public _FinalStage catalogVersion(Long catalogVersion) {
            this.catalogVersion = Optional.ofNullable(catalogVersion);
            return this;
        }

        @Override
        @JsonSetter(value="catalog_version", nulls=Nulls.SKIP)
        public _FinalStage catalogVersion(Optional<Long> catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        @Override
        public _FinalStage catalogObjectId(Nullable<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId.isNull() ? null : (catalogObjectId.isEmpty() ? Optional.empty() : Optional.of(catalogObjectId.get()));
            return this;
        }

        @Override
        public _FinalStage catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = Optional.ofNullable(catalogObjectId);
            return this;
        }

        @Override
        @JsonSetter(value="catalog_object_id", nulls=Nulls.SKIP)
        public _FinalStage catalogObjectId(Optional<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        @Override
        public _FinalStage note(Nullable<String> note) {
            this.note = note.isNull() ? null : (note.isEmpty() ? Optional.empty() : Optional.of(note.get()));
            return this;
        }

        @Override
        public _FinalStage note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @Override
        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public _FinalStage note(Optional<String> note) {
            this.note = note;
            return this;
        }

        @Override
        public _FinalStage quantityUnit(OrderQuantityUnit quantityUnit) {
            this.quantityUnit = Optional.ofNullable(quantityUnit);
            return this;
        }

        @Override
        @JsonSetter(value="quantity_unit", nulls=Nulls.SKIP)
        public _FinalStage quantityUnit(Optional<OrderQuantityUnit> quantityUnit) {
            this.quantityUnit = quantityUnit;
            return this;
        }

        @Override
        public _FinalStage name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage sourceLineItemUid(Nullable<String> sourceLineItemUid) {
            this.sourceLineItemUid = sourceLineItemUid.isNull() ? null : (sourceLineItemUid.isEmpty() ? Optional.empty() : Optional.of(sourceLineItemUid.get()));
            return this;
        }

        @Override
        public _FinalStage sourceLineItemUid(String sourceLineItemUid) {
            this.sourceLineItemUid = Optional.ofNullable(sourceLineItemUid);
            return this;
        }

        @Override
        @JsonSetter(value="source_line_item_uid", nulls=Nulls.SKIP)
        public _FinalStage sourceLineItemUid(Optional<String> sourceLineItemUid) {
            this.sourceLineItemUid = sourceLineItemUid;
            return this;
        }

        @Override
        public _FinalStage uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @Override
        public _FinalStage uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        @Override
        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public _FinalStage uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        @Override
        public OrderReturnLineItem build() {
            return new OrderReturnLineItem(this.uid, this.sourceLineItemUid, this.name, this.quantity, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.returnModifiers, this.appliedTaxes, this.appliedDiscounts, this.basePriceMoney, this.variationTotalPriceMoney, this.grossReturnMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney, this.appliedServiceCharges, this.totalServiceChargeMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrderReturnLineItem build();

        public _FinalStage uid(Optional<String> var1);

        public _FinalStage uid(String var1);

        public _FinalStage uid(Nullable<String> var1);

        public _FinalStage sourceLineItemUid(Optional<String> var1);

        public _FinalStage sourceLineItemUid(String var1);

        public _FinalStage sourceLineItemUid(Nullable<String> var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage name(Nullable<String> var1);

        public _FinalStage quantityUnit(Optional<OrderQuantityUnit> var1);

        public _FinalStage quantityUnit(OrderQuantityUnit var1);

        public _FinalStage note(Optional<String> var1);

        public _FinalStage note(String var1);

        public _FinalStage note(Nullable<String> var1);

        public _FinalStage catalogObjectId(Optional<String> var1);

        public _FinalStage catalogObjectId(String var1);

        public _FinalStage catalogObjectId(Nullable<String> var1);

        public _FinalStage catalogVersion(Optional<Long> var1);

        public _FinalStage catalogVersion(Long var1);

        public _FinalStage catalogVersion(Nullable<Long> var1);

        public _FinalStage variationName(Optional<String> var1);

        public _FinalStage variationName(String var1);

        public _FinalStage variationName(Nullable<String> var1);

        public _FinalStage itemType(Optional<OrderLineItemItemType> var1);

        public _FinalStage itemType(OrderLineItemItemType var1);

        public _FinalStage returnModifiers(Optional<List<OrderReturnLineItemModifier>> var1);

        public _FinalStage returnModifiers(List<OrderReturnLineItemModifier> var1);

        public _FinalStage returnModifiers(Nullable<List<OrderReturnLineItemModifier>> var1);

        public _FinalStage appliedTaxes(Optional<List<OrderLineItemAppliedTax>> var1);

        public _FinalStage appliedTaxes(List<OrderLineItemAppliedTax> var1);

        public _FinalStage appliedTaxes(Nullable<List<OrderLineItemAppliedTax>> var1);

        public _FinalStage appliedDiscounts(Optional<List<OrderLineItemAppliedDiscount>> var1);

        public _FinalStage appliedDiscounts(List<OrderLineItemAppliedDiscount> var1);

        public _FinalStage appliedDiscounts(Nullable<List<OrderLineItemAppliedDiscount>> var1);

        public _FinalStage basePriceMoney(Optional<Money> var1);

        public _FinalStage basePriceMoney(Money var1);

        public _FinalStage variationTotalPriceMoney(Optional<Money> var1);

        public _FinalStage variationTotalPriceMoney(Money var1);

        public _FinalStage grossReturnMoney(Optional<Money> var1);

        public _FinalStage grossReturnMoney(Money var1);

        public _FinalStage totalTaxMoney(Optional<Money> var1);

        public _FinalStage totalTaxMoney(Money var1);

        public _FinalStage totalDiscountMoney(Optional<Money> var1);

        public _FinalStage totalDiscountMoney(Money var1);

        public _FinalStage totalMoney(Optional<Money> var1);

        public _FinalStage totalMoney(Money var1);

        public _FinalStage appliedServiceCharges(Optional<List<OrderLineItemAppliedServiceCharge>> var1);

        public _FinalStage appliedServiceCharges(List<OrderLineItemAppliedServiceCharge> var1);

        public _FinalStage appliedServiceCharges(Nullable<List<OrderLineItemAppliedServiceCharge>> var1);

        public _FinalStage totalServiceChargeMoney(Optional<Money> var1);

        public _FinalStage totalServiceChargeMoney(Money var1);
    }

    public static interface QuantityStage {
        public _FinalStage quantity(@NotNull String var1);

        public Builder from(OrderReturnLineItem var1);
    }
}

