/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.MeasurementUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderQuantityUnit {
    private final Optional<MeasurementUnit> measurementUnit;
    private final Optional<Integer> precision;
    private final Optional<String> catalogObjectId;
    private final Optional<Long> catalogVersion;
    private final Map<String, Object> additionalProperties;

    private OrderQuantityUnit(Optional<MeasurementUnit> measurementUnit, Optional<Integer> precision, Optional<String> catalogObjectId, Optional<Long> catalogVersion, Map<String, Object> additionalProperties) {
        this.measurementUnit = measurementUnit;
        this.precision = precision;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="measurement_unit")
    public Optional<MeasurementUnit> getMeasurementUnit() {
        return this.measurementUnit;
    }

    @JsonIgnore
    public Optional<Integer> getPrecision() {
        if (this.precision == null) {
            return Optional.empty();
        }
        return this.precision;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectId() {
        if (this.catalogObjectId == null) {
            return Optional.empty();
        }
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<Long> getCatalogVersion() {
        if (this.catalogVersion == null) {
            return Optional.empty();
        }
        return this.catalogVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="precision")
    private Optional<Integer> _getPrecision() {
        return this.precision;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_id")
    private Optional<String> _getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_version")
    private Optional<Long> _getCatalogVersion() {
        return this.catalogVersion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderQuantityUnit && this.equalTo((OrderQuantityUnit)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderQuantityUnit other) {
        return this.measurementUnit.equals(other.measurementUnit) && this.precision.equals(other.precision) && this.catalogObjectId.equals(other.catalogObjectId) && this.catalogVersion.equals(other.catalogVersion);
    }

    public int hashCode() {
        return Objects.hash(this.measurementUnit, this.precision, this.catalogObjectId, this.catalogVersion);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<MeasurementUnit> measurementUnit = Optional.empty();
        private Optional<Integer> precision = Optional.empty();
        private Optional<String> catalogObjectId = Optional.empty();
        private Optional<Long> catalogVersion = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderQuantityUnit other) {
            this.measurementUnit(other.getMeasurementUnit());
            this.precision(other.getPrecision());
            this.catalogObjectId(other.getCatalogObjectId());
            this.catalogVersion(other.getCatalogVersion());
            return this;
        }

        @JsonSetter(value="measurement_unit", nulls=Nulls.SKIP)
        public Builder measurementUnit(Optional<MeasurementUnit> measurementUnit) {
            this.measurementUnit = measurementUnit;
            return this;
        }

        public Builder measurementUnit(MeasurementUnit measurementUnit) {
            this.measurementUnit = Optional.ofNullable(measurementUnit);
            return this;
        }

        @JsonSetter(value="precision", nulls=Nulls.SKIP)
        public Builder precision(Optional<Integer> precision) {
            this.precision = precision;
            return this;
        }

        public Builder precision(Integer precision) {
            this.precision = Optional.ofNullable(precision);
            return this;
        }

        public Builder precision(Nullable<Integer> precision) {
            this.precision = precision.isNull() ? null : (precision.isEmpty() ? Optional.empty() : Optional.of(precision.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_id", nulls=Nulls.SKIP)
        public Builder catalogObjectId(Optional<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = Optional.ofNullable(catalogObjectId);
            return this;
        }

        public Builder catalogObjectId(Nullable<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId.isNull() ? null : (catalogObjectId.isEmpty() ? Optional.empty() : Optional.of(catalogObjectId.get()));
            return this;
        }

        @JsonSetter(value="catalog_version", nulls=Nulls.SKIP)
        public Builder catalogVersion(Optional<Long> catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = Optional.ofNullable(catalogVersion);
            return this;
        }

        public Builder catalogVersion(Nullable<Long> catalogVersion) {
            this.catalogVersion = catalogVersion.isNull() ? null : (catalogVersion.isEmpty() ? Optional.empty() : Optional.of(catalogVersion.get()));
            return this;
        }

        public OrderQuantityUnit build() {
            return new OrderQuantityUnit(this.measurementUnit, this.precision, this.catalogObjectId, this.catalogVersion, this.additionalProperties);
        }
    }
}

