/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderMoneyAmounts {
    private final Optional<Money> totalMoney;
    private final Optional<Money> taxMoney;
    private final Optional<Money> discountMoney;
    private final Optional<Money> tipMoney;
    private final Optional<Money> serviceChargeMoney;
    private final Map<String, Object> additionalProperties;

    private OrderMoneyAmounts(Optional<Money> totalMoney, Optional<Money> taxMoney, Optional<Money> discountMoney, Optional<Money> tipMoney, Optional<Money> serviceChargeMoney, Map<String, Object> additionalProperties) {
        this.totalMoney = totalMoney;
        this.taxMoney = taxMoney;
        this.discountMoney = discountMoney;
        this.tipMoney = tipMoney;
        this.serviceChargeMoney = serviceChargeMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="total_money")
    public Optional<Money> getTotalMoney() {
        return this.totalMoney;
    }

    @JsonProperty(value="tax_money")
    public Optional<Money> getTaxMoney() {
        return this.taxMoney;
    }

    @JsonProperty(value="discount_money")
    public Optional<Money> getDiscountMoney() {
        return this.discountMoney;
    }

    @JsonProperty(value="tip_money")
    public Optional<Money> getTipMoney() {
        return this.tipMoney;
    }

    @JsonProperty(value="service_charge_money")
    public Optional<Money> getServiceChargeMoney() {
        return this.serviceChargeMoney;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderMoneyAmounts && this.equalTo((OrderMoneyAmounts)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderMoneyAmounts other) {
        return this.totalMoney.equals(other.totalMoney) && this.taxMoney.equals(other.taxMoney) && this.discountMoney.equals(other.discountMoney) && this.tipMoney.equals(other.tipMoney) && this.serviceChargeMoney.equals(other.serviceChargeMoney);
    }

    public int hashCode() {
        return Objects.hash(this.totalMoney, this.taxMoney, this.discountMoney, this.tipMoney, this.serviceChargeMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Money> totalMoney = Optional.empty();
        private Optional<Money> taxMoney = Optional.empty();
        private Optional<Money> discountMoney = Optional.empty();
        private Optional<Money> tipMoney = Optional.empty();
        private Optional<Money> serviceChargeMoney = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderMoneyAmounts other) {
            this.totalMoney(other.getTotalMoney());
            this.taxMoney(other.getTaxMoney());
            this.discountMoney(other.getDiscountMoney());
            this.tipMoney(other.getTipMoney());
            this.serviceChargeMoney(other.getServiceChargeMoney());
            return this;
        }

        @JsonSetter(value="total_money", nulls=Nulls.SKIP)
        public Builder totalMoney(Optional<Money> totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = Optional.ofNullable(totalMoney);
            return this;
        }

        @JsonSetter(value="tax_money", nulls=Nulls.SKIP)
        public Builder taxMoney(Optional<Money> taxMoney) {
            this.taxMoney = taxMoney;
            return this;
        }

        public Builder taxMoney(Money taxMoney) {
            this.taxMoney = Optional.ofNullable(taxMoney);
            return this;
        }

        @JsonSetter(value="discount_money", nulls=Nulls.SKIP)
        public Builder discountMoney(Optional<Money> discountMoney) {
            this.discountMoney = discountMoney;
            return this;
        }

        public Builder discountMoney(Money discountMoney) {
            this.discountMoney = Optional.ofNullable(discountMoney);
            return this;
        }

        @JsonSetter(value="tip_money", nulls=Nulls.SKIP)
        public Builder tipMoney(Optional<Money> tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        public Builder tipMoney(Money tipMoney) {
            this.tipMoney = Optional.ofNullable(tipMoney);
            return this;
        }

        @JsonSetter(value="service_charge_money", nulls=Nulls.SKIP)
        public Builder serviceChargeMoney(Optional<Money> serviceChargeMoney) {
            this.serviceChargeMoney = serviceChargeMoney;
            return this;
        }

        public Builder serviceChargeMoney(Money serviceChargeMoney) {
            this.serviceChargeMoney = Optional.ofNullable(serviceChargeMoney);
            return this;
        }

        public OrderMoneyAmounts build() {
            return new OrderMoneyAmounts(this.totalMoney, this.taxMoney, this.discountMoney, this.tipMoney, this.serviceChargeMoney, this.additionalProperties);
        }
    }
}

