/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.OrderLineItemPricingBlocklistsBlockedDiscount;
import com.squareup.square.types.OrderLineItemPricingBlocklistsBlockedTax;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderLineItemPricingBlocklists {
    private final Optional<List<OrderLineItemPricingBlocklistsBlockedDiscount>> blockedDiscounts;
    private final Optional<List<OrderLineItemPricingBlocklistsBlockedTax>> blockedTaxes;
    private final Map<String, Object> additionalProperties;

    private OrderLineItemPricingBlocklists(Optional<List<OrderLineItemPricingBlocklistsBlockedDiscount>> blockedDiscounts, Optional<List<OrderLineItemPricingBlocklistsBlockedTax>> blockedTaxes, Map<String, Object> additionalProperties) {
        this.blockedDiscounts = blockedDiscounts;
        this.blockedTaxes = blockedTaxes;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<OrderLineItemPricingBlocklistsBlockedDiscount>> getBlockedDiscounts() {
        if (this.blockedDiscounts == null) {
            return Optional.empty();
        }
        return this.blockedDiscounts;
    }

    @JsonIgnore
    public Optional<List<OrderLineItemPricingBlocklistsBlockedTax>> getBlockedTaxes() {
        if (this.blockedTaxes == null) {
            return Optional.empty();
        }
        return this.blockedTaxes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="blocked_discounts")
    private Optional<List<OrderLineItemPricingBlocklistsBlockedDiscount>> _getBlockedDiscounts() {
        return this.blockedDiscounts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="blocked_taxes")
    private Optional<List<OrderLineItemPricingBlocklistsBlockedTax>> _getBlockedTaxes() {
        return this.blockedTaxes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderLineItemPricingBlocklists && this.equalTo((OrderLineItemPricingBlocklists)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderLineItemPricingBlocklists other) {
        return this.blockedDiscounts.equals(other.blockedDiscounts) && this.blockedTaxes.equals(other.blockedTaxes);
    }

    public int hashCode() {
        return Objects.hash(this.blockedDiscounts, this.blockedTaxes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<OrderLineItemPricingBlocklistsBlockedDiscount>> blockedDiscounts = Optional.empty();
        private Optional<List<OrderLineItemPricingBlocklistsBlockedTax>> blockedTaxes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderLineItemPricingBlocklists other) {
            this.blockedDiscounts(other.getBlockedDiscounts());
            this.blockedTaxes(other.getBlockedTaxes());
            return this;
        }

        @JsonSetter(value="blocked_discounts", nulls=Nulls.SKIP)
        public Builder blockedDiscounts(Optional<List<OrderLineItemPricingBlocklistsBlockedDiscount>> blockedDiscounts) {
            this.blockedDiscounts = blockedDiscounts;
            return this;
        }

        public Builder blockedDiscounts(List<OrderLineItemPricingBlocklistsBlockedDiscount> blockedDiscounts) {
            this.blockedDiscounts = Optional.ofNullable(blockedDiscounts);
            return this;
        }

        public Builder blockedDiscounts(Nullable<List<OrderLineItemPricingBlocklistsBlockedDiscount>> blockedDiscounts) {
            this.blockedDiscounts = blockedDiscounts.isNull() ? null : (blockedDiscounts.isEmpty() ? Optional.empty() : Optional.of(blockedDiscounts.get()));
            return this;
        }

        @JsonSetter(value="blocked_taxes", nulls=Nulls.SKIP)
        public Builder blockedTaxes(Optional<List<OrderLineItemPricingBlocklistsBlockedTax>> blockedTaxes) {
            this.blockedTaxes = blockedTaxes;
            return this;
        }

        public Builder blockedTaxes(List<OrderLineItemPricingBlocklistsBlockedTax> blockedTaxes) {
            this.blockedTaxes = Optional.ofNullable(blockedTaxes);
            return this;
        }

        public Builder blockedTaxes(Nullable<List<OrderLineItemPricingBlocklistsBlockedTax>> blockedTaxes) {
            this.blockedTaxes = blockedTaxes.isNull() ? null : (blockedTaxes.isEmpty() ? Optional.empty() : Optional.of(blockedTaxes.get()));
            return this;
        }

        public OrderLineItemPricingBlocklists build() {
            return new OrderLineItemPricingBlocklists(this.blockedDiscounts, this.blockedTaxes, this.additionalProperties);
        }
    }
}

