/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class OrderLineItemDiscountType {
    public static final OrderLineItemDiscountType FIXED_PERCENTAGE = new OrderLineItemDiscountType(Value.FIXED_PERCENTAGE, "FIXED_PERCENTAGE");
    public static final OrderLineItemDiscountType FIXED_AMOUNT = new OrderLineItemDiscountType(Value.FIXED_AMOUNT, "FIXED_AMOUNT");
    public static final OrderLineItemDiscountType UNKNOWN_DISCOUNT = new OrderLineItemDiscountType(Value.UNKNOWN_DISCOUNT, "UNKNOWN_DISCOUNT");
    public static final OrderLineItemDiscountType VARIABLE_AMOUNT = new OrderLineItemDiscountType(Value.VARIABLE_AMOUNT, "VARIABLE_AMOUNT");
    public static final OrderLineItemDiscountType VARIABLE_PERCENTAGE = new OrderLineItemDiscountType(Value.VARIABLE_PERCENTAGE, "VARIABLE_PERCENTAGE");
    private final Value value;
    private final String string;

    OrderLineItemDiscountType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof OrderLineItemDiscountType && this.string.equals(((OrderLineItemDiscountType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case FIXED_PERCENTAGE: {
                return visitor.visitFixedPercentage();
            }
            case FIXED_AMOUNT: {
                return visitor.visitFixedAmount();
            }
            case UNKNOWN_DISCOUNT: {
                return visitor.visitUnknownDiscount();
            }
            case VARIABLE_AMOUNT: {
                return visitor.visitVariableAmount();
            }
            case VARIABLE_PERCENTAGE: {
                return visitor.visitVariablePercentage();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static OrderLineItemDiscountType valueOf(String value) {
        switch (value) {
            case "FIXED_PERCENTAGE": {
                return FIXED_PERCENTAGE;
            }
            case "FIXED_AMOUNT": {
                return FIXED_AMOUNT;
            }
            case "UNKNOWN_DISCOUNT": {
                return UNKNOWN_DISCOUNT;
            }
            case "VARIABLE_AMOUNT": {
                return VARIABLE_AMOUNT;
            }
            case "VARIABLE_PERCENTAGE": {
                return VARIABLE_PERCENTAGE;
            }
        }
        return new OrderLineItemDiscountType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitUnknownDiscount();

        public T visitFixedPercentage();

        public T visitFixedAmount();

        public T visitVariablePercentage();

        public T visitVariableAmount();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        UNKNOWN_DISCOUNT,
        FIXED_PERCENTAGE,
        FIXED_AMOUNT,
        VARIABLE_PERCENTAGE,
        VARIABLE_AMOUNT,
        UNKNOWN;

    }
}

