/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import com.squareup.square.types.OrderLineItemDiscountScope;
import com.squareup.square.types.OrderLineItemDiscountType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderLineItemDiscount {
    private final Optional<String> uid;
    private final Optional<String> catalogObjectId;
    private final Optional<Long> catalogVersion;
    private final Optional<String> name;
    private final Optional<OrderLineItemDiscountType> type;
    private final Optional<String> percentage;
    private final Optional<Money> amountMoney;
    private final Optional<Money> appliedMoney;
    private final Optional<Map<String, Optional<String>>> metadata;
    private final Optional<OrderLineItemDiscountScope> scope;
    private final Optional<List<String>> rewardIds;
    private final Optional<String> pricingRuleId;
    private final Map<String, Object> additionalProperties;

    private OrderLineItemDiscount(Optional<String> uid, Optional<String> catalogObjectId, Optional<Long> catalogVersion, Optional<String> name, Optional<OrderLineItemDiscountType> type, Optional<String> percentage, Optional<Money> amountMoney, Optional<Money> appliedMoney, Optional<Map<String, Optional<String>>> metadata, Optional<OrderLineItemDiscountScope> scope, Optional<List<String>> rewardIds, Optional<String> pricingRuleId, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.name = name;
        this.type = type;
        this.percentage = percentage;
        this.amountMoney = amountMoney;
        this.appliedMoney = appliedMoney;
        this.metadata = metadata;
        this.scope = scope;
        this.rewardIds = rewardIds;
        this.pricingRuleId = pricingRuleId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectId() {
        if (this.catalogObjectId == null) {
            return Optional.empty();
        }
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<Long> getCatalogVersion() {
        if (this.catalogVersion == null) {
            return Optional.empty();
        }
        return this.catalogVersion;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="type")
    public Optional<OrderLineItemDiscountType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getPercentage() {
        if (this.percentage == null) {
            return Optional.empty();
        }
        return this.percentage;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="applied_money")
    public Optional<Money> getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonIgnore
    public Optional<Map<String, Optional<String>>> getMetadata() {
        if (this.metadata == null) {
            return Optional.empty();
        }
        return this.metadata;
    }

    @JsonProperty(value="scope")
    public Optional<OrderLineItemDiscountScope> getScope() {
        return this.scope;
    }

    @JsonProperty(value="reward_ids")
    public Optional<List<String>> getRewardIds() {
        return this.rewardIds;
    }

    @JsonProperty(value="pricing_rule_id")
    public Optional<String> getPricingRuleId() {
        return this.pricingRuleId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_id")
    private Optional<String> _getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_version")
    private Optional<Long> _getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="percentage")
    private Optional<String> _getPercentage() {
        return this.percentage;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="metadata")
    private Optional<Map<String, Optional<String>>> _getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderLineItemDiscount && this.equalTo((OrderLineItemDiscount)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderLineItemDiscount other) {
        return this.uid.equals(other.uid) && this.catalogObjectId.equals(other.catalogObjectId) && this.catalogVersion.equals(other.catalogVersion) && this.name.equals(other.name) && this.type.equals(other.type) && this.percentage.equals(other.percentage) && this.amountMoney.equals(other.amountMoney) && this.appliedMoney.equals(other.appliedMoney) && this.metadata.equals(other.metadata) && this.scope.equals(other.scope) && this.rewardIds.equals(other.rewardIds) && this.pricingRuleId.equals(other.pricingRuleId);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.type, this.percentage, this.amountMoney, this.appliedMoney, this.metadata, this.scope, this.rewardIds, this.pricingRuleId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<String> catalogObjectId = Optional.empty();
        private Optional<Long> catalogVersion = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<OrderLineItemDiscountType> type = Optional.empty();
        private Optional<String> percentage = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<Money> appliedMoney = Optional.empty();
        private Optional<Map<String, Optional<String>>> metadata = Optional.empty();
        private Optional<OrderLineItemDiscountScope> scope = Optional.empty();
        private Optional<List<String>> rewardIds = Optional.empty();
        private Optional<String> pricingRuleId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderLineItemDiscount other) {
            this.uid(other.getUid());
            this.catalogObjectId(other.getCatalogObjectId());
            this.catalogVersion(other.getCatalogVersion());
            this.name(other.getName());
            this.type(other.getType());
            this.percentage(other.getPercentage());
            this.amountMoney(other.getAmountMoney());
            this.appliedMoney(other.getAppliedMoney());
            this.metadata(other.getMetadata());
            this.scope(other.getScope());
            this.rewardIds(other.getRewardIds());
            this.pricingRuleId(other.getPricingRuleId());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_id", nulls=Nulls.SKIP)
        public Builder catalogObjectId(Optional<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = Optional.ofNullable(catalogObjectId);
            return this;
        }

        public Builder catalogObjectId(Nullable<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId.isNull() ? null : (catalogObjectId.isEmpty() ? Optional.empty() : Optional.of(catalogObjectId.get()));
            return this;
        }

        @JsonSetter(value="catalog_version", nulls=Nulls.SKIP)
        public Builder catalogVersion(Optional<Long> catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = Optional.ofNullable(catalogVersion);
            return this;
        }

        public Builder catalogVersion(Nullable<Long> catalogVersion) {
            this.catalogVersion = catalogVersion.isNull() ? null : (catalogVersion.isEmpty() ? Optional.empty() : Optional.of(catalogVersion.get()));
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<OrderLineItemDiscountType> type) {
            this.type = type;
            return this;
        }

        public Builder type(OrderLineItemDiscountType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="percentage", nulls=Nulls.SKIP)
        public Builder percentage(Optional<String> percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = Optional.ofNullable(percentage);
            return this;
        }

        public Builder percentage(Nullable<String> percentage) {
            this.percentage = percentage.isNull() ? null : (percentage.isEmpty() ? Optional.empty() : Optional.of(percentage.get()));
            return this;
        }

        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public Builder amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @JsonSetter(value="applied_money", nulls=Nulls.SKIP)
        public Builder appliedMoney(Optional<Money> appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = Optional.ofNullable(appliedMoney);
            return this;
        }

        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public Builder metadata(Optional<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(Map<String, Optional<String>> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        public Builder metadata(Nullable<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata.isNull() ? null : (metadata.isEmpty() ? Optional.empty() : Optional.of(metadata.get()));
            return this;
        }

        @JsonSetter(value="scope", nulls=Nulls.SKIP)
        public Builder scope(Optional<OrderLineItemDiscountScope> scope) {
            this.scope = scope;
            return this;
        }

        public Builder scope(OrderLineItemDiscountScope scope) {
            this.scope = Optional.ofNullable(scope);
            return this;
        }

        @JsonSetter(value="reward_ids", nulls=Nulls.SKIP)
        public Builder rewardIds(Optional<List<String>> rewardIds) {
            this.rewardIds = rewardIds;
            return this;
        }

        public Builder rewardIds(List<String> rewardIds) {
            this.rewardIds = Optional.ofNullable(rewardIds);
            return this;
        }

        @JsonSetter(value="pricing_rule_id", nulls=Nulls.SKIP)
        public Builder pricingRuleId(Optional<String> pricingRuleId) {
            this.pricingRuleId = pricingRuleId;
            return this;
        }

        public Builder pricingRuleId(String pricingRuleId) {
            this.pricingRuleId = Optional.ofNullable(pricingRuleId);
            return this;
        }

        public OrderLineItemDiscount build() {
            return new OrderLineItemDiscount(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.type, this.percentage, this.amountMoney, this.appliedMoney, this.metadata, this.scope, this.rewardIds, this.pricingRuleId, this.additionalProperties);
        }
    }
}

