/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.FulfillmentState;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderFulfillmentUpdatedUpdate {
    private final Optional<String> fulfillmentUid;
    private final Optional<FulfillmentState> oldState;
    private final Optional<FulfillmentState> newState;
    private final Map<String, Object> additionalProperties;

    private OrderFulfillmentUpdatedUpdate(Optional<String> fulfillmentUid, Optional<FulfillmentState> oldState, Optional<FulfillmentState> newState, Map<String, Object> additionalProperties) {
        this.fulfillmentUid = fulfillmentUid;
        this.oldState = oldState;
        this.newState = newState;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getFulfillmentUid() {
        if (this.fulfillmentUid == null) {
            return Optional.empty();
        }
        return this.fulfillmentUid;
    }

    @JsonProperty(value="old_state")
    public Optional<FulfillmentState> getOldState() {
        return this.oldState;
    }

    @JsonProperty(value="new_state")
    public Optional<FulfillmentState> getNewState() {
        return this.newState;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fulfillment_uid")
    private Optional<String> _getFulfillmentUid() {
        return this.fulfillmentUid;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderFulfillmentUpdatedUpdate && this.equalTo((OrderFulfillmentUpdatedUpdate)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderFulfillmentUpdatedUpdate other) {
        return this.fulfillmentUid.equals(other.fulfillmentUid) && this.oldState.equals(other.oldState) && this.newState.equals(other.newState);
    }

    public int hashCode() {
        return Objects.hash(this.fulfillmentUid, this.oldState, this.newState);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> fulfillmentUid = Optional.empty();
        private Optional<FulfillmentState> oldState = Optional.empty();
        private Optional<FulfillmentState> newState = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderFulfillmentUpdatedUpdate other) {
            this.fulfillmentUid(other.getFulfillmentUid());
            this.oldState(other.getOldState());
            this.newState(other.getNewState());
            return this;
        }

        @JsonSetter(value="fulfillment_uid", nulls=Nulls.SKIP)
        public Builder fulfillmentUid(Optional<String> fulfillmentUid) {
            this.fulfillmentUid = fulfillmentUid;
            return this;
        }

        public Builder fulfillmentUid(String fulfillmentUid) {
            this.fulfillmentUid = Optional.ofNullable(fulfillmentUid);
            return this;
        }

        public Builder fulfillmentUid(Nullable<String> fulfillmentUid) {
            this.fulfillmentUid = fulfillmentUid.isNull() ? null : (fulfillmentUid.isEmpty() ? Optional.empty() : Optional.of(fulfillmentUid.get()));
            return this;
        }

        @JsonSetter(value="old_state", nulls=Nulls.SKIP)
        public Builder oldState(Optional<FulfillmentState> oldState) {
            this.oldState = oldState;
            return this;
        }

        public Builder oldState(FulfillmentState oldState) {
            this.oldState = Optional.ofNullable(oldState);
            return this;
        }

        @JsonSetter(value="new_state", nulls=Nulls.SKIP)
        public Builder newState(Optional<FulfillmentState> newState) {
            this.newState = newState;
            return this;
        }

        public Builder newState(FulfillmentState newState) {
            this.newState = Optional.ofNullable(newState);
            return this;
        }

        public OrderFulfillmentUpdatedUpdate build() {
            return new OrderFulfillmentUpdatedUpdate(this.fulfillmentUid, this.oldState, this.newState, this.additionalProperties);
        }
    }
}

