/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObjectReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyProgramRewardTier {
    private final Optional<String> id;
    private final int points;
    private final Optional<String> name;
    private final Optional<String> createdAt;
    private final CatalogObjectReference pricingRuleReference;
    private final Map<String, Object> additionalProperties;

    private LoyaltyProgramRewardTier(Optional<String> id, int points, Optional<String> name, Optional<String> createdAt, CatalogObjectReference pricingRuleReference, Map<String, Object> additionalProperties) {
        this.id = id;
        this.points = points;
        this.name = name;
        this.createdAt = createdAt;
        this.pricingRuleReference = pricingRuleReference;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="points")
    public int getPoints() {
        return this.points;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="pricing_rule_reference")
    public CatalogObjectReference getPricingRuleReference() {
        return this.pricingRuleReference;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyProgramRewardTier && this.equalTo((LoyaltyProgramRewardTier)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyProgramRewardTier other) {
        return this.id.equals(other.id) && this.points == other.points && this.name.equals(other.name) && this.createdAt.equals(other.createdAt) && this.pricingRuleReference.equals(other.pricingRuleReference);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.points, this.name, this.createdAt, this.pricingRuleReference);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PointsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PointsStage,
    PricingRuleReferenceStage,
    _FinalStage {
        private int points;
        private CatalogObjectReference pricingRuleReference;
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyProgramRewardTier other) {
            this.id(other.getId());
            this.points(other.getPoints());
            this.name(other.getName());
            this.createdAt(other.getCreatedAt());
            this.pricingRuleReference(other.getPricingRuleReference());
            return this;
        }

        @Override
        @JsonSetter(value="points")
        public PricingRuleReferenceStage points(int points) {
            this.points = points;
            return this;
        }

        @Override
        @JsonSetter(value="pricing_rule_reference")
        public _FinalStage pricingRuleReference(@NotNull CatalogObjectReference pricingRuleReference) {
            this.pricingRuleReference = Objects.requireNonNull(pricingRuleReference, "pricingRuleReference must not be null");
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public LoyaltyProgramRewardTier build() {
            return new LoyaltyProgramRewardTier(this.id, this.points, this.name, this.createdAt, this.pricingRuleReference, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyProgramRewardTier build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);
    }

    public static interface PricingRuleReferenceStage {
        public _FinalStage pricingRuleReference(@NotNull CatalogObjectReference var1);
    }

    public static interface PointsStage {
        public PricingRuleReferenceStage points(int var1);

        public Builder from(LoyaltyProgramRewardTier var1);
    }
}

