/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyProgramAccrualRuleTaxMode;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyProgramAccrualRuleSpendData {
    private final Money amountMoney;
    private final Optional<List<String>> excludedCategoryIds;
    private final Optional<List<String>> excludedItemVariationIds;
    private final LoyaltyProgramAccrualRuleTaxMode taxMode;
    private final Map<String, Object> additionalProperties;

    private LoyaltyProgramAccrualRuleSpendData(Money amountMoney, Optional<List<String>> excludedCategoryIds, Optional<List<String>> excludedItemVariationIds, LoyaltyProgramAccrualRuleTaxMode taxMode, Map<String, Object> additionalProperties) {
        this.amountMoney = amountMoney;
        this.excludedCategoryIds = excludedCategoryIds;
        this.excludedItemVariationIds = excludedItemVariationIds;
        this.taxMode = taxMode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonIgnore
    public Optional<List<String>> getExcludedCategoryIds() {
        if (this.excludedCategoryIds == null) {
            return Optional.empty();
        }
        return this.excludedCategoryIds;
    }

    @JsonIgnore
    public Optional<List<String>> getExcludedItemVariationIds() {
        if (this.excludedItemVariationIds == null) {
            return Optional.empty();
        }
        return this.excludedItemVariationIds;
    }

    @JsonProperty(value="tax_mode")
    public LoyaltyProgramAccrualRuleTaxMode getTaxMode() {
        return this.taxMode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="excluded_category_ids")
    private Optional<List<String>> _getExcludedCategoryIds() {
        return this.excludedCategoryIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="excluded_item_variation_ids")
    private Optional<List<String>> _getExcludedItemVariationIds() {
        return this.excludedItemVariationIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyProgramAccrualRuleSpendData && this.equalTo((LoyaltyProgramAccrualRuleSpendData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyProgramAccrualRuleSpendData other) {
        return this.amountMoney.equals(other.amountMoney) && this.excludedCategoryIds.equals(other.excludedCategoryIds) && this.excludedItemVariationIds.equals(other.excludedItemVariationIds) && this.taxMode.equals(other.taxMode);
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.excludedCategoryIds, this.excludedItemVariationIds, this.taxMode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountMoneyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountMoneyStage,
    TaxModeStage,
    _FinalStage {
        private Money amountMoney;
        private LoyaltyProgramAccrualRuleTaxMode taxMode;
        private Optional<List<String>> excludedItemVariationIds = Optional.empty();
        private Optional<List<String>> excludedCategoryIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyProgramAccrualRuleSpendData other) {
            this.amountMoney(other.getAmountMoney());
            this.excludedCategoryIds(other.getExcludedCategoryIds());
            this.excludedItemVariationIds(other.getExcludedItemVariationIds());
            this.taxMode(other.getTaxMode());
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public TaxModeStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="tax_mode")
        public _FinalStage taxMode(@NotNull LoyaltyProgramAccrualRuleTaxMode taxMode) {
            this.taxMode = Objects.requireNonNull(taxMode, "taxMode must not be null");
            return this;
        }

        @Override
        public _FinalStage excludedItemVariationIds(Nullable<List<String>> excludedItemVariationIds) {
            this.excludedItemVariationIds = excludedItemVariationIds.isNull() ? null : (excludedItemVariationIds.isEmpty() ? Optional.empty() : Optional.of(excludedItemVariationIds.get()));
            return this;
        }

        @Override
        public _FinalStage excludedItemVariationIds(List<String> excludedItemVariationIds) {
            this.excludedItemVariationIds = Optional.ofNullable(excludedItemVariationIds);
            return this;
        }

        @Override
        @JsonSetter(value="excluded_item_variation_ids", nulls=Nulls.SKIP)
        public _FinalStage excludedItemVariationIds(Optional<List<String>> excludedItemVariationIds) {
            this.excludedItemVariationIds = excludedItemVariationIds;
            return this;
        }

        @Override
        public _FinalStage excludedCategoryIds(Nullable<List<String>> excludedCategoryIds) {
            this.excludedCategoryIds = excludedCategoryIds.isNull() ? null : (excludedCategoryIds.isEmpty() ? Optional.empty() : Optional.of(excludedCategoryIds.get()));
            return this;
        }

        @Override
        public _FinalStage excludedCategoryIds(List<String> excludedCategoryIds) {
            this.excludedCategoryIds = Optional.ofNullable(excludedCategoryIds);
            return this;
        }

        @Override
        @JsonSetter(value="excluded_category_ids", nulls=Nulls.SKIP)
        public _FinalStage excludedCategoryIds(Optional<List<String>> excludedCategoryIds) {
            this.excludedCategoryIds = excludedCategoryIds;
            return this;
        }

        @Override
        public LoyaltyProgramAccrualRuleSpendData build() {
            return new LoyaltyProgramAccrualRuleSpendData(this.amountMoney, this.excludedCategoryIds, this.excludedItemVariationIds, this.taxMode, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyProgramAccrualRuleSpendData build();

        public _FinalStage excludedCategoryIds(Optional<List<String>> var1);

        public _FinalStage excludedCategoryIds(List<String> var1);

        public _FinalStage excludedCategoryIds(Nullable<List<String>> var1);

        public _FinalStage excludedItemVariationIds(Optional<List<String>> var1);

        public _FinalStage excludedItemVariationIds(List<String> var1);

        public _FinalStage excludedItemVariationIds(Nullable<List<String>> var1);
    }

    public static interface TaxModeStage {
        public _FinalStage taxMode(@NotNull LoyaltyProgramAccrualRuleTaxMode var1);
    }

    public static interface AmountMoneyStage {
        public TaxModeStage amountMoney(@NotNull Money var1);

        public Builder from(LoyaltyProgramAccrualRuleSpendData var1);
    }
}

