/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyProgramAccrualRuleCategoryData;
import com.squareup.square.types.LoyaltyProgramAccrualRuleItemVariationData;
import com.squareup.square.types.LoyaltyProgramAccrualRuleSpendData;
import com.squareup.square.types.LoyaltyProgramAccrualRuleType;
import com.squareup.square.types.LoyaltyProgramAccrualRuleVisitData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyProgramAccrualRule {
    private final LoyaltyProgramAccrualRuleType accrualType;
    private final Optional<Integer> points;
    private final Optional<LoyaltyProgramAccrualRuleVisitData> visitData;
    private final Optional<LoyaltyProgramAccrualRuleSpendData> spendData;
    private final Optional<LoyaltyProgramAccrualRuleItemVariationData> itemVariationData;
    private final Optional<LoyaltyProgramAccrualRuleCategoryData> categoryData;
    private final Map<String, Object> additionalProperties;

    private LoyaltyProgramAccrualRule(LoyaltyProgramAccrualRuleType accrualType, Optional<Integer> points, Optional<LoyaltyProgramAccrualRuleVisitData> visitData, Optional<LoyaltyProgramAccrualRuleSpendData> spendData, Optional<LoyaltyProgramAccrualRuleItemVariationData> itemVariationData, Optional<LoyaltyProgramAccrualRuleCategoryData> categoryData, Map<String, Object> additionalProperties) {
        this.accrualType = accrualType;
        this.points = points;
        this.visitData = visitData;
        this.spendData = spendData;
        this.itemVariationData = itemVariationData;
        this.categoryData = categoryData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="accrual_type")
    public LoyaltyProgramAccrualRuleType getAccrualType() {
        return this.accrualType;
    }

    @JsonIgnore
    public Optional<Integer> getPoints() {
        if (this.points == null) {
            return Optional.empty();
        }
        return this.points;
    }

    @JsonProperty(value="visit_data")
    public Optional<LoyaltyProgramAccrualRuleVisitData> getVisitData() {
        return this.visitData;
    }

    @JsonProperty(value="spend_data")
    public Optional<LoyaltyProgramAccrualRuleSpendData> getSpendData() {
        return this.spendData;
    }

    @JsonProperty(value="item_variation_data")
    public Optional<LoyaltyProgramAccrualRuleItemVariationData> getItemVariationData() {
        return this.itemVariationData;
    }

    @JsonProperty(value="category_data")
    public Optional<LoyaltyProgramAccrualRuleCategoryData> getCategoryData() {
        return this.categoryData;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="points")
    private Optional<Integer> _getPoints() {
        return this.points;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyProgramAccrualRule && this.equalTo((LoyaltyProgramAccrualRule)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyProgramAccrualRule other) {
        return this.accrualType.equals(other.accrualType) && this.points.equals(other.points) && this.visitData.equals(other.visitData) && this.spendData.equals(other.spendData) && this.itemVariationData.equals(other.itemVariationData) && this.categoryData.equals(other.categoryData);
    }

    public int hashCode() {
        return Objects.hash(this.accrualType, this.points, this.visitData, this.spendData, this.itemVariationData, this.categoryData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccrualTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccrualTypeStage,
    _FinalStage {
        private LoyaltyProgramAccrualRuleType accrualType;
        private Optional<LoyaltyProgramAccrualRuleCategoryData> categoryData = Optional.empty();
        private Optional<LoyaltyProgramAccrualRuleItemVariationData> itemVariationData = Optional.empty();
        private Optional<LoyaltyProgramAccrualRuleSpendData> spendData = Optional.empty();
        private Optional<LoyaltyProgramAccrualRuleVisitData> visitData = Optional.empty();
        private Optional<Integer> points = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyProgramAccrualRule other) {
            this.accrualType(other.getAccrualType());
            this.points(other.getPoints());
            this.visitData(other.getVisitData());
            this.spendData(other.getSpendData());
            this.itemVariationData(other.getItemVariationData());
            this.categoryData(other.getCategoryData());
            return this;
        }

        @Override
        @JsonSetter(value="accrual_type")
        public _FinalStage accrualType(@NotNull LoyaltyProgramAccrualRuleType accrualType) {
            this.accrualType = Objects.requireNonNull(accrualType, "accrualType must not be null");
            return this;
        }

        @Override
        public _FinalStage categoryData(LoyaltyProgramAccrualRuleCategoryData categoryData) {
            this.categoryData = Optional.ofNullable(categoryData);
            return this;
        }

        @Override
        @JsonSetter(value="category_data", nulls=Nulls.SKIP)
        public _FinalStage categoryData(Optional<LoyaltyProgramAccrualRuleCategoryData> categoryData) {
            this.categoryData = categoryData;
            return this;
        }

        @Override
        public _FinalStage itemVariationData(LoyaltyProgramAccrualRuleItemVariationData itemVariationData) {
            this.itemVariationData = Optional.ofNullable(itemVariationData);
            return this;
        }

        @Override
        @JsonSetter(value="item_variation_data", nulls=Nulls.SKIP)
        public _FinalStage itemVariationData(Optional<LoyaltyProgramAccrualRuleItemVariationData> itemVariationData) {
            this.itemVariationData = itemVariationData;
            return this;
        }

        @Override
        public _FinalStage spendData(LoyaltyProgramAccrualRuleSpendData spendData) {
            this.spendData = Optional.ofNullable(spendData);
            return this;
        }

        @Override
        @JsonSetter(value="spend_data", nulls=Nulls.SKIP)
        public _FinalStage spendData(Optional<LoyaltyProgramAccrualRuleSpendData> spendData) {
            this.spendData = spendData;
            return this;
        }

        @Override
        public _FinalStage visitData(LoyaltyProgramAccrualRuleVisitData visitData) {
            this.visitData = Optional.ofNullable(visitData);
            return this;
        }

        @Override
        @JsonSetter(value="visit_data", nulls=Nulls.SKIP)
        public _FinalStage visitData(Optional<LoyaltyProgramAccrualRuleVisitData> visitData) {
            this.visitData = visitData;
            return this;
        }

        @Override
        public _FinalStage points(Nullable<Integer> points) {
            this.points = points.isNull() ? null : (points.isEmpty() ? Optional.empty() : Optional.of(points.get()));
            return this;
        }

        @Override
        public _FinalStage points(Integer points) {
            this.points = Optional.ofNullable(points);
            return this;
        }

        @Override
        @JsonSetter(value="points", nulls=Nulls.SKIP)
        public _FinalStage points(Optional<Integer> points) {
            this.points = points;
            return this;
        }

        @Override
        public LoyaltyProgramAccrualRule build() {
            return new LoyaltyProgramAccrualRule(this.accrualType, this.points, this.visitData, this.spendData, this.itemVariationData, this.categoryData, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyProgramAccrualRule build();

        public _FinalStage points(Optional<Integer> var1);

        public _FinalStage points(Integer var1);

        public _FinalStage points(Nullable<Integer> var1);

        public _FinalStage visitData(Optional<LoyaltyProgramAccrualRuleVisitData> var1);

        public _FinalStage visitData(LoyaltyProgramAccrualRuleVisitData var1);

        public _FinalStage spendData(Optional<LoyaltyProgramAccrualRuleSpendData> var1);

        public _FinalStage spendData(LoyaltyProgramAccrualRuleSpendData var1);

        public _FinalStage itemVariationData(Optional<LoyaltyProgramAccrualRuleItemVariationData> var1);

        public _FinalStage itemVariationData(LoyaltyProgramAccrualRuleItemVariationData var1);

        public _FinalStage categoryData(Optional<LoyaltyProgramAccrualRuleCategoryData> var1);

        public _FinalStage categoryData(LoyaltyProgramAccrualRuleCategoryData var1);
    }

    public static interface AccrualTypeStage {
        public _FinalStage accrualType(@NotNull LoyaltyProgramAccrualRuleType var1);

        public Builder from(LoyaltyProgramAccrualRule var1);
    }
}

