/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyProgramAccrualRule;
import com.squareup.square.types.LoyaltyProgramExpirationPolicy;
import com.squareup.square.types.LoyaltyProgramRewardTier;
import com.squareup.square.types.LoyaltyProgramStatus;
import com.squareup.square.types.LoyaltyProgramTerminology;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyProgram {
    private final Optional<String> id;
    private final Optional<LoyaltyProgramStatus> status;
    private final Optional<List<LoyaltyProgramRewardTier>> rewardTiers;
    private final Optional<LoyaltyProgramExpirationPolicy> expirationPolicy;
    private final Optional<LoyaltyProgramTerminology> terminology;
    private final Optional<List<String>> locationIds;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<List<LoyaltyProgramAccrualRule>> accrualRules;
    private final Map<String, Object> additionalProperties;

    private LoyaltyProgram(Optional<String> id, Optional<LoyaltyProgramStatus> status, Optional<List<LoyaltyProgramRewardTier>> rewardTiers, Optional<LoyaltyProgramExpirationPolicy> expirationPolicy, Optional<LoyaltyProgramTerminology> terminology, Optional<List<String>> locationIds, Optional<String> createdAt, Optional<String> updatedAt, Optional<List<LoyaltyProgramAccrualRule>> accrualRules, Map<String, Object> additionalProperties) {
        this.id = id;
        this.status = status;
        this.rewardTiers = rewardTiers;
        this.expirationPolicy = expirationPolicy;
        this.terminology = terminology;
        this.locationIds = locationIds;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.accrualRules = accrualRules;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public Optional<LoyaltyProgramStatus> getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Optional<List<LoyaltyProgramRewardTier>> getRewardTiers() {
        if (this.rewardTiers == null) {
            return Optional.empty();
        }
        return this.rewardTiers;
    }

    @JsonProperty(value="expiration_policy")
    public Optional<LoyaltyProgramExpirationPolicy> getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @JsonProperty(value="terminology")
    public Optional<LoyaltyProgramTerminology> getTerminology() {
        return this.terminology;
    }

    @JsonIgnore
    public Optional<List<String>> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<List<LoyaltyProgramAccrualRule>> getAccrualRules() {
        if (this.accrualRules == null) {
            return Optional.empty();
        }
        return this.accrualRules;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reward_tiers")
    private Optional<List<LoyaltyProgramRewardTier>> _getRewardTiers() {
        return this.rewardTiers;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<List<String>> _getLocationIds() {
        return this.locationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="accrual_rules")
    private Optional<List<LoyaltyProgramAccrualRule>> _getAccrualRules() {
        return this.accrualRules;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyProgram && this.equalTo((LoyaltyProgram)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyProgram other) {
        return this.id.equals(other.id) && this.status.equals(other.status) && this.rewardTiers.equals(other.rewardTiers) && this.expirationPolicy.equals(other.expirationPolicy) && this.terminology.equals(other.terminology) && this.locationIds.equals(other.locationIds) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.accrualRules.equals(other.accrualRules);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.rewardTiers, this.expirationPolicy, this.terminology, this.locationIds, this.createdAt, this.updatedAt, this.accrualRules);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<LoyaltyProgramStatus> status = Optional.empty();
        private Optional<List<LoyaltyProgramRewardTier>> rewardTiers = Optional.empty();
        private Optional<LoyaltyProgramExpirationPolicy> expirationPolicy = Optional.empty();
        private Optional<LoyaltyProgramTerminology> terminology = Optional.empty();
        private Optional<List<String>> locationIds = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<List<LoyaltyProgramAccrualRule>> accrualRules = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LoyaltyProgram other) {
            this.id(other.getId());
            this.status(other.getStatus());
            this.rewardTiers(other.getRewardTiers());
            this.expirationPolicy(other.getExpirationPolicy());
            this.terminology(other.getTerminology());
            this.locationIds(other.getLocationIds());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.accrualRules(other.getAccrualRules());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<LoyaltyProgramStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(LoyaltyProgramStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="reward_tiers", nulls=Nulls.SKIP)
        public Builder rewardTiers(Optional<List<LoyaltyProgramRewardTier>> rewardTiers) {
            this.rewardTiers = rewardTiers;
            return this;
        }

        public Builder rewardTiers(List<LoyaltyProgramRewardTier> rewardTiers) {
            this.rewardTiers = Optional.ofNullable(rewardTiers);
            return this;
        }

        public Builder rewardTiers(Nullable<List<LoyaltyProgramRewardTier>> rewardTiers) {
            this.rewardTiers = rewardTiers.isNull() ? null : (rewardTiers.isEmpty() ? Optional.empty() : Optional.of(rewardTiers.get()));
            return this;
        }

        @JsonSetter(value="expiration_policy", nulls=Nulls.SKIP)
        public Builder expirationPolicy(Optional<LoyaltyProgramExpirationPolicy> expirationPolicy) {
            this.expirationPolicy = expirationPolicy;
            return this;
        }

        public Builder expirationPolicy(LoyaltyProgramExpirationPolicy expirationPolicy) {
            this.expirationPolicy = Optional.ofNullable(expirationPolicy);
            return this;
        }

        @JsonSetter(value="terminology", nulls=Nulls.SKIP)
        public Builder terminology(Optional<LoyaltyProgramTerminology> terminology) {
            this.terminology = terminology;
            return this;
        }

        public Builder terminology(LoyaltyProgramTerminology terminology) {
            this.terminology = Optional.ofNullable(terminology);
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        public Builder locationIds(Nullable<List<String>> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="accrual_rules", nulls=Nulls.SKIP)
        public Builder accrualRules(Optional<List<LoyaltyProgramAccrualRule>> accrualRules) {
            this.accrualRules = accrualRules;
            return this;
        }

        public Builder accrualRules(List<LoyaltyProgramAccrualRule> accrualRules) {
            this.accrualRules = Optional.ofNullable(accrualRules);
            return this;
        }

        public Builder accrualRules(Nullable<List<LoyaltyProgramAccrualRule>> accrualRules) {
            this.accrualRules = accrualRules.isNull() ? null : (accrualRules.isEmpty() ? Optional.empty() : Optional.of(accrualRules.get()));
            return this;
        }

        public LoyaltyProgram build() {
            return new LoyaltyProgram(this.id, this.status, this.rewardTiers, this.expirationPolicy, this.terminology, this.locationIds, this.createdAt, this.updatedAt, this.accrualRules, this.additionalProperties);
        }
    }
}

