/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyEventAccumulatePromotionPoints {
    private final Optional<String> loyaltyProgramId;
    private final Optional<String> loyaltyPromotionId;
    private final Optional<Integer> points;
    private final Optional<String> orderId;
    private final Map<String, Object> additionalProperties;

    private LoyaltyEventAccumulatePromotionPoints(Optional<String> loyaltyProgramId, Optional<String> loyaltyPromotionId, Optional<Integer> points, Optional<String> orderId, Map<String, Object> additionalProperties) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.loyaltyPromotionId = loyaltyPromotionId;
        this.points = points;
        this.orderId = orderId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="loyalty_program_id")
    public Optional<String> getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonProperty(value="loyalty_promotion_id")
    public Optional<String> getLoyaltyPromotionId() {
        return this.loyaltyPromotionId;
    }

    @JsonProperty(value="points")
    public Optional<Integer> getPoints() {
        return this.points;
    }

    @JsonProperty(value="order_id")
    public Optional<String> getOrderId() {
        return this.orderId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyEventAccumulatePromotionPoints && this.equalTo((LoyaltyEventAccumulatePromotionPoints)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyEventAccumulatePromotionPoints other) {
        return this.loyaltyProgramId.equals(other.loyaltyProgramId) && this.loyaltyPromotionId.equals(other.loyaltyPromotionId) && this.points.equals(other.points) && this.orderId.equals(other.orderId);
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.loyaltyPromotionId, this.points, this.orderId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> loyaltyProgramId = Optional.empty();
        private Optional<String> loyaltyPromotionId = Optional.empty();
        private Optional<Integer> points = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LoyaltyEventAccumulatePromotionPoints other) {
            this.loyaltyProgramId(other.getLoyaltyProgramId());
            this.loyaltyPromotionId(other.getLoyaltyPromotionId());
            this.points(other.getPoints());
            this.orderId(other.getOrderId());
            return this;
        }

        @JsonSetter(value="loyalty_program_id", nulls=Nulls.SKIP)
        public Builder loyaltyProgramId(Optional<String> loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = Optional.ofNullable(loyaltyProgramId);
            return this;
        }

        @JsonSetter(value="loyalty_promotion_id", nulls=Nulls.SKIP)
        public Builder loyaltyPromotionId(Optional<String> loyaltyPromotionId) {
            this.loyaltyPromotionId = loyaltyPromotionId;
            return this;
        }

        public Builder loyaltyPromotionId(String loyaltyPromotionId) {
            this.loyaltyPromotionId = Optional.ofNullable(loyaltyPromotionId);
            return this;
        }

        @JsonSetter(value="points", nulls=Nulls.SKIP)
        public Builder points(Optional<Integer> points) {
            this.points = points;
            return this;
        }

        public Builder points(Integer points) {
            this.points = Optional.ofNullable(points);
            return this;
        }

        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public Builder orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        public LoyaltyEventAccumulatePromotionPoints build() {
            return new LoyaltyEventAccumulatePromotionPoints(this.loyaltyProgramId, this.loyaltyPromotionId, this.points, this.orderId, this.additionalProperties);
        }
    }
}

