/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyEventAccumulatePoints {
    private final Optional<String> loyaltyProgramId;
    private final Optional<Integer> points;
    private final Optional<String> orderId;
    private final Map<String, Object> additionalProperties;

    private LoyaltyEventAccumulatePoints(Optional<String> loyaltyProgramId, Optional<Integer> points, Optional<String> orderId, Map<String, Object> additionalProperties) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.points = points;
        this.orderId = orderId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="loyalty_program_id")
    public Optional<String> getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonIgnore
    public Optional<Integer> getPoints() {
        if (this.points == null) {
            return Optional.empty();
        }
        return this.points;
    }

    @JsonIgnore
    public Optional<String> getOrderId() {
        if (this.orderId == null) {
            return Optional.empty();
        }
        return this.orderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="points")
    private Optional<Integer> _getPoints() {
        return this.points;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_id")
    private Optional<String> _getOrderId() {
        return this.orderId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyEventAccumulatePoints && this.equalTo((LoyaltyEventAccumulatePoints)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyEventAccumulatePoints other) {
        return this.loyaltyProgramId.equals(other.loyaltyProgramId) && this.points.equals(other.points) && this.orderId.equals(other.orderId);
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.points, this.orderId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> loyaltyProgramId = Optional.empty();
        private Optional<Integer> points = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LoyaltyEventAccumulatePoints other) {
            this.loyaltyProgramId(other.getLoyaltyProgramId());
            this.points(other.getPoints());
            this.orderId(other.getOrderId());
            return this;
        }

        @JsonSetter(value="loyalty_program_id", nulls=Nulls.SKIP)
        public Builder loyaltyProgramId(Optional<String> loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = Optional.ofNullable(loyaltyProgramId);
            return this;
        }

        @JsonSetter(value="points", nulls=Nulls.SKIP)
        public Builder points(Optional<Integer> points) {
            this.points = points;
            return this;
        }

        public Builder points(Integer points) {
            this.points = Optional.ofNullable(points);
            return this;
        }

        public Builder points(Nullable<Integer> points) {
            this.points = points.isNull() ? null : (points.isEmpty() ? Optional.empty() : Optional.of(points.get()));
            return this;
        }

        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public Builder orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        public Builder orderId(Nullable<String> orderId) {
            this.orderId = orderId.isNull() ? null : (orderId.isEmpty() ? Optional.empty() : Optional.of(orderId.get()));
            return this;
        }

        public LoyaltyEventAccumulatePoints build() {
            return new LoyaltyEventAccumulatePoints(this.loyaltyProgramId, this.points, this.orderId, this.additionalProperties);
        }
    }
}

