/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyAccountExpiringPointDeadline;
import com.squareup.square.types.LoyaltyAccountMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyAccount {
    private final Optional<String> id;
    private final String programId;
    private final Optional<Integer> balance;
    private final Optional<Integer> lifetimePoints;
    private final Optional<String> customerId;
    private final Optional<String> enrolledAt;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<LoyaltyAccountMapping> mapping;
    private final Optional<List<LoyaltyAccountExpiringPointDeadline>> expiringPointDeadlines;
    private final Map<String, Object> additionalProperties;

    private LoyaltyAccount(Optional<String> id, String programId, Optional<Integer> balance, Optional<Integer> lifetimePoints, Optional<String> customerId, Optional<String> enrolledAt, Optional<String> createdAt, Optional<String> updatedAt, Optional<LoyaltyAccountMapping> mapping, Optional<List<LoyaltyAccountExpiringPointDeadline>> expiringPointDeadlines, Map<String, Object> additionalProperties) {
        this.id = id;
        this.programId = programId;
        this.balance = balance;
        this.lifetimePoints = lifetimePoints;
        this.customerId = customerId;
        this.enrolledAt = enrolledAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.mapping = mapping;
        this.expiringPointDeadlines = expiringPointDeadlines;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="program_id")
    public String getProgramId() {
        return this.programId;
    }

    @JsonProperty(value="balance")
    public Optional<Integer> getBalance() {
        return this.balance;
    }

    @JsonProperty(value="lifetime_points")
    public Optional<Integer> getLifetimePoints() {
        return this.lifetimePoints;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonIgnore
    public Optional<String> getEnrolledAt() {
        if (this.enrolledAt == null) {
            return Optional.empty();
        }
        return this.enrolledAt;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="mapping")
    public Optional<LoyaltyAccountMapping> getMapping() {
        return this.mapping;
    }

    @JsonIgnore
    public Optional<List<LoyaltyAccountExpiringPointDeadline>> getExpiringPointDeadlines() {
        if (this.expiringPointDeadlines == null) {
            return Optional.empty();
        }
        return this.expiringPointDeadlines;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="enrolled_at")
    private Optional<String> _getEnrolledAt() {
        return this.enrolledAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="expiring_point_deadlines")
    private Optional<List<LoyaltyAccountExpiringPointDeadline>> _getExpiringPointDeadlines() {
        return this.expiringPointDeadlines;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyAccount && this.equalTo((LoyaltyAccount)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyAccount other) {
        return this.id.equals(other.id) && this.programId.equals(other.programId) && this.balance.equals(other.balance) && this.lifetimePoints.equals(other.lifetimePoints) && this.customerId.equals(other.customerId) && this.enrolledAt.equals(other.enrolledAt) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.mapping.equals(other.mapping) && this.expiringPointDeadlines.equals(other.expiringPointDeadlines);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.programId, this.balance, this.lifetimePoints, this.customerId, this.enrolledAt, this.createdAt, this.updatedAt, this.mapping, this.expiringPointDeadlines);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProgramIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProgramIdStage,
    _FinalStage {
        private String programId;
        private Optional<List<LoyaltyAccountExpiringPointDeadline>> expiringPointDeadlines = Optional.empty();
        private Optional<LoyaltyAccountMapping> mapping = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> enrolledAt = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<Integer> lifetimePoints = Optional.empty();
        private Optional<Integer> balance = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyAccount other) {
            this.id(other.getId());
            this.programId(other.getProgramId());
            this.balance(other.getBalance());
            this.lifetimePoints(other.getLifetimePoints());
            this.customerId(other.getCustomerId());
            this.enrolledAt(other.getEnrolledAt());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.mapping(other.getMapping());
            this.expiringPointDeadlines(other.getExpiringPointDeadlines());
            return this;
        }

        @Override
        @JsonSetter(value="program_id")
        public _FinalStage programId(@NotNull String programId) {
            this.programId = Objects.requireNonNull(programId, "programId must not be null");
            return this;
        }

        @Override
        public _FinalStage expiringPointDeadlines(Nullable<List<LoyaltyAccountExpiringPointDeadline>> expiringPointDeadlines) {
            this.expiringPointDeadlines = expiringPointDeadlines.isNull() ? null : (expiringPointDeadlines.isEmpty() ? Optional.empty() : Optional.of(expiringPointDeadlines.get()));
            return this;
        }

        @Override
        public _FinalStage expiringPointDeadlines(List<LoyaltyAccountExpiringPointDeadline> expiringPointDeadlines) {
            this.expiringPointDeadlines = Optional.ofNullable(expiringPointDeadlines);
            return this;
        }

        @Override
        @JsonSetter(value="expiring_point_deadlines", nulls=Nulls.SKIP)
        public _FinalStage expiringPointDeadlines(Optional<List<LoyaltyAccountExpiringPointDeadline>> expiringPointDeadlines) {
            this.expiringPointDeadlines = expiringPointDeadlines;
            return this;
        }

        @Override
        public _FinalStage mapping(LoyaltyAccountMapping mapping) {
            this.mapping = Optional.ofNullable(mapping);
            return this;
        }

        @Override
        @JsonSetter(value="mapping", nulls=Nulls.SKIP)
        public _FinalStage mapping(Optional<LoyaltyAccountMapping> mapping) {
            this.mapping = mapping;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage enrolledAt(Nullable<String> enrolledAt) {
            this.enrolledAt = enrolledAt.isNull() ? null : (enrolledAt.isEmpty() ? Optional.empty() : Optional.of(enrolledAt.get()));
            return this;
        }

        @Override
        public _FinalStage enrolledAt(String enrolledAt) {
            this.enrolledAt = Optional.ofNullable(enrolledAt);
            return this;
        }

        @Override
        @JsonSetter(value="enrolled_at", nulls=Nulls.SKIP)
        public _FinalStage enrolledAt(Optional<String> enrolledAt) {
            this.enrolledAt = enrolledAt;
            return this;
        }

        @Override
        public _FinalStage customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @Override
        public _FinalStage customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        @Override
        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public _FinalStage customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        @Override
        public _FinalStage lifetimePoints(Integer lifetimePoints) {
            this.lifetimePoints = Optional.ofNullable(lifetimePoints);
            return this;
        }

        @Override
        @JsonSetter(value="lifetime_points", nulls=Nulls.SKIP)
        public _FinalStage lifetimePoints(Optional<Integer> lifetimePoints) {
            this.lifetimePoints = lifetimePoints;
            return this;
        }

        @Override
        public _FinalStage balance(Integer balance) {
            this.balance = Optional.ofNullable(balance);
            return this;
        }

        @Override
        @JsonSetter(value="balance", nulls=Nulls.SKIP)
        public _FinalStage balance(Optional<Integer> balance) {
            this.balance = balance;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public LoyaltyAccount build() {
            return new LoyaltyAccount(this.id, this.programId, this.balance, this.lifetimePoints, this.customerId, this.enrolledAt, this.createdAt, this.updatedAt, this.mapping, this.expiringPointDeadlines, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyAccount build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage balance(Optional<Integer> var1);

        public _FinalStage balance(Integer var1);

        public _FinalStage lifetimePoints(Optional<Integer> var1);

        public _FinalStage lifetimePoints(Integer var1);

        public _FinalStage customerId(Optional<String> var1);

        public _FinalStage customerId(String var1);

        public _FinalStage customerId(Nullable<String> var1);

        public _FinalStage enrolledAt(Optional<String> var1);

        public _FinalStage enrolledAt(String var1);

        public _FinalStage enrolledAt(Nullable<String> var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage mapping(Optional<LoyaltyAccountMapping> var1);

        public _FinalStage mapping(LoyaltyAccountMapping var1);

        public _FinalStage expiringPointDeadlines(Optional<List<LoyaltyAccountExpiringPointDeadline>> var1);

        public _FinalStage expiringPointDeadlines(List<LoyaltyAccountExpiringPointDeadline> var1);

        public _FinalStage expiringPointDeadlines(Nullable<List<LoyaltyAccountExpiringPointDeadline>> var1);
    }

    public static interface ProgramIdStage {
        public _FinalStage programId(@NotNull String var1);

        public Builder from(LoyaltyAccount var1);
    }
}

