/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LocationBookingProfile {
    private final Optional<String> locationId;
    private final Optional<String> bookingSiteUrl;
    private final Optional<Boolean> onlineBookingEnabled;
    private final Map<String, Object> additionalProperties;

    private LocationBookingProfile(Optional<String> locationId, Optional<String> bookingSiteUrl, Optional<Boolean> onlineBookingEnabled, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.bookingSiteUrl = bookingSiteUrl;
        this.onlineBookingEnabled = onlineBookingEnabled;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getBookingSiteUrl() {
        if (this.bookingSiteUrl == null) {
            return Optional.empty();
        }
        return this.bookingSiteUrl;
    }

    @JsonIgnore
    public Optional<Boolean> getOnlineBookingEnabled() {
        if (this.onlineBookingEnabled == null) {
            return Optional.empty();
        }
        return this.onlineBookingEnabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="booking_site_url")
    private Optional<String> _getBookingSiteUrl() {
        return this.bookingSiteUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="online_booking_enabled")
    private Optional<Boolean> _getOnlineBookingEnabled() {
        return this.onlineBookingEnabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LocationBookingProfile && this.equalTo((LocationBookingProfile)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LocationBookingProfile other) {
        return this.locationId.equals(other.locationId) && this.bookingSiteUrl.equals(other.bookingSiteUrl) && this.onlineBookingEnabled.equals(other.onlineBookingEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.bookingSiteUrl, this.onlineBookingEnabled);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> locationId = Optional.empty();
        private Optional<String> bookingSiteUrl = Optional.empty();
        private Optional<Boolean> onlineBookingEnabled = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LocationBookingProfile other) {
            this.locationId(other.getLocationId());
            this.bookingSiteUrl(other.getBookingSiteUrl());
            this.onlineBookingEnabled(other.getOnlineBookingEnabled());
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="booking_site_url", nulls=Nulls.SKIP)
        public Builder bookingSiteUrl(Optional<String> bookingSiteUrl) {
            this.bookingSiteUrl = bookingSiteUrl;
            return this;
        }

        public Builder bookingSiteUrl(String bookingSiteUrl) {
            this.bookingSiteUrl = Optional.ofNullable(bookingSiteUrl);
            return this;
        }

        public Builder bookingSiteUrl(Nullable<String> bookingSiteUrl) {
            this.bookingSiteUrl = bookingSiteUrl.isNull() ? null : (bookingSiteUrl.isEmpty() ? Optional.empty() : Optional.of(bookingSiteUrl.get()));
            return this;
        }

        @JsonSetter(value="online_booking_enabled", nulls=Nulls.SKIP)
        public Builder onlineBookingEnabled(Optional<Boolean> onlineBookingEnabled) {
            this.onlineBookingEnabled = onlineBookingEnabled;
            return this;
        }

        public Builder onlineBookingEnabled(Boolean onlineBookingEnabled) {
            this.onlineBookingEnabled = Optional.ofNullable(onlineBookingEnabled);
            return this;
        }

        public Builder onlineBookingEnabled(Nullable<Boolean> onlineBookingEnabled) {
            this.onlineBookingEnabled = onlineBookingEnabled.isNull() ? null : (onlineBookingEnabled.isEmpty() ? Optional.empty() : Optional.of(onlineBookingEnabled.get()));
            return this;
        }

        public LocationBookingProfile build() {
            return new LocationBookingProfile(this.locationId, this.bookingSiteUrl, this.onlineBookingEnabled, this.additionalProperties);
        }
    }
}

