/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.BusinessHours;
import com.squareup.square.types.Coordinates;
import com.squareup.square.types.Country;
import com.squareup.square.types.Currency;
import com.squareup.square.types.LocationCapability;
import com.squareup.square.types.LocationStatus;
import com.squareup.square.types.LocationType;
import com.squareup.square.types.TaxIds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Location {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<Address> address;
    private final Optional<String> timezone;
    private final Optional<List<LocationCapability>> capabilities;
    private final Optional<LocationStatus> status;
    private final Optional<String> createdAt;
    private final Optional<String> merchantId;
    private final Optional<Country> country;
    private final Optional<String> languageCode;
    private final Optional<Currency> currency;
    private final Optional<String> phoneNumber;
    private final Optional<String> businessName;
    private final Optional<LocationType> type;
    private final Optional<String> websiteUrl;
    private final Optional<BusinessHours> businessHours;
    private final Optional<String> businessEmail;
    private final Optional<String> description;
    private final Optional<String> twitterUsername;
    private final Optional<String> instagramUsername;
    private final Optional<String> facebookUrl;
    private final Optional<Coordinates> coordinates;
    private final Optional<String> logoUrl;
    private final Optional<String> posBackgroundUrl;
    private final Optional<String> mcc;
    private final Optional<String> fullFormatLogoUrl;
    private final Optional<TaxIds> taxIds;
    private final Map<String, Object> additionalProperties;

    private Location(Optional<String> id, Optional<String> name, Optional<Address> address, Optional<String> timezone, Optional<List<LocationCapability>> capabilities, Optional<LocationStatus> status, Optional<String> createdAt, Optional<String> merchantId, Optional<Country> country, Optional<String> languageCode, Optional<Currency> currency, Optional<String> phoneNumber, Optional<String> businessName, Optional<LocationType> type, Optional<String> websiteUrl, Optional<BusinessHours> businessHours, Optional<String> businessEmail, Optional<String> description, Optional<String> twitterUsername, Optional<String> instagramUsername, Optional<String> facebookUrl, Optional<Coordinates> coordinates, Optional<String> logoUrl, Optional<String> posBackgroundUrl, Optional<String> mcc, Optional<String> fullFormatLogoUrl, Optional<TaxIds> taxIds, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.timezone = timezone;
        this.capabilities = capabilities;
        this.status = status;
        this.createdAt = createdAt;
        this.merchantId = merchantId;
        this.country = country;
        this.languageCode = languageCode;
        this.currency = currency;
        this.phoneNumber = phoneNumber;
        this.businessName = businessName;
        this.type = type;
        this.websiteUrl = websiteUrl;
        this.businessHours = businessHours;
        this.businessEmail = businessEmail;
        this.description = description;
        this.twitterUsername = twitterUsername;
        this.instagramUsername = instagramUsername;
        this.facebookUrl = facebookUrl;
        this.coordinates = coordinates;
        this.logoUrl = logoUrl;
        this.posBackgroundUrl = posBackgroundUrl;
        this.mcc = mcc;
        this.fullFormatLogoUrl = fullFormatLogoUrl;
        this.taxIds = taxIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="address")
    public Optional<Address> getAddress() {
        return this.address;
    }

    @JsonIgnore
    public Optional<String> getTimezone() {
        if (this.timezone == null) {
            return Optional.empty();
        }
        return this.timezone;
    }

    @JsonProperty(value="capabilities")
    public Optional<List<LocationCapability>> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="status")
    public Optional<LocationStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="merchant_id")
    public Optional<String> getMerchantId() {
        return this.merchantId;
    }

    @JsonProperty(value="country")
    public Optional<Country> getCountry() {
        return this.country;
    }

    @JsonIgnore
    public Optional<String> getLanguageCode() {
        if (this.languageCode == null) {
            return Optional.empty();
        }
        return this.languageCode;
    }

    @JsonProperty(value="currency")
    public Optional<Currency> getCurrency() {
        return this.currency;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        if (this.phoneNumber == null) {
            return Optional.empty();
        }
        return this.phoneNumber;
    }

    @JsonIgnore
    public Optional<String> getBusinessName() {
        if (this.businessName == null) {
            return Optional.empty();
        }
        return this.businessName;
    }

    @JsonProperty(value="type")
    public Optional<LocationType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getWebsiteUrl() {
        if (this.websiteUrl == null) {
            return Optional.empty();
        }
        return this.websiteUrl;
    }

    @JsonProperty(value="business_hours")
    public Optional<BusinessHours> getBusinessHours() {
        return this.businessHours;
    }

    @JsonIgnore
    public Optional<String> getBusinessEmail() {
        if (this.businessEmail == null) {
            return Optional.empty();
        }
        return this.businessEmail;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonIgnore
    public Optional<String> getTwitterUsername() {
        if (this.twitterUsername == null) {
            return Optional.empty();
        }
        return this.twitterUsername;
    }

    @JsonIgnore
    public Optional<String> getInstagramUsername() {
        if (this.instagramUsername == null) {
            return Optional.empty();
        }
        return this.instagramUsername;
    }

    @JsonIgnore
    public Optional<String> getFacebookUrl() {
        if (this.facebookUrl == null) {
            return Optional.empty();
        }
        return this.facebookUrl;
    }

    @JsonProperty(value="coordinates")
    public Optional<Coordinates> getCoordinates() {
        return this.coordinates;
    }

    @JsonProperty(value="logo_url")
    public Optional<String> getLogoUrl() {
        return this.logoUrl;
    }

    @JsonProperty(value="pos_background_url")
    public Optional<String> getPosBackgroundUrl() {
        return this.posBackgroundUrl;
    }

    @JsonIgnore
    public Optional<String> getMcc() {
        if (this.mcc == null) {
            return Optional.empty();
        }
        return this.mcc;
    }

    @JsonProperty(value="full_format_logo_url")
    public Optional<String> getFullFormatLogoUrl() {
        return this.fullFormatLogoUrl;
    }

    @JsonProperty(value="tax_ids")
    public Optional<TaxIds> getTaxIds() {
        return this.taxIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="timezone")
    private Optional<String> _getTimezone() {
        return this.timezone;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="language_code")
    private Optional<String> _getLanguageCode() {
        return this.languageCode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number")
    private Optional<String> _getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="business_name")
    private Optional<String> _getBusinessName() {
        return this.businessName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="website_url")
    private Optional<String> _getWebsiteUrl() {
        return this.websiteUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="business_email")
    private Optional<String> _getBusinessEmail() {
        return this.businessEmail;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="twitter_username")
    private Optional<String> _getTwitterUsername() {
        return this.twitterUsername;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="instagram_username")
    private Optional<String> _getInstagramUsername() {
        return this.instagramUsername;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="facebook_url")
    private Optional<String> _getFacebookUrl() {
        return this.facebookUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="mcc")
    private Optional<String> _getMcc() {
        return this.mcc;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Location && this.equalTo((Location)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Location other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.address.equals(other.address) && this.timezone.equals(other.timezone) && this.capabilities.equals(other.capabilities) && this.status.equals(other.status) && this.createdAt.equals(other.createdAt) && this.merchantId.equals(other.merchantId) && this.country.equals(other.country) && this.languageCode.equals(other.languageCode) && this.currency.equals(other.currency) && this.phoneNumber.equals(other.phoneNumber) && this.businessName.equals(other.businessName) && this.type.equals(other.type) && this.websiteUrl.equals(other.websiteUrl) && this.businessHours.equals(other.businessHours) && this.businessEmail.equals(other.businessEmail) && this.description.equals(other.description) && this.twitterUsername.equals(other.twitterUsername) && this.instagramUsername.equals(other.instagramUsername) && this.facebookUrl.equals(other.facebookUrl) && this.coordinates.equals(other.coordinates) && this.logoUrl.equals(other.logoUrl) && this.posBackgroundUrl.equals(other.posBackgroundUrl) && this.mcc.equals(other.mcc) && this.fullFormatLogoUrl.equals(other.fullFormatLogoUrl) && this.taxIds.equals(other.taxIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.address, this.timezone, this.capabilities, this.status, this.createdAt, this.merchantId, this.country, this.languageCode, this.currency, this.phoneNumber, this.businessName, this.type, this.websiteUrl, this.businessHours, this.businessEmail, this.description, this.twitterUsername, this.instagramUsername, this.facebookUrl, this.coordinates, this.logoUrl, this.posBackgroundUrl, this.mcc, this.fullFormatLogoUrl, this.taxIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Address> address = Optional.empty();
        private Optional<String> timezone = Optional.empty();
        private Optional<List<LocationCapability>> capabilities = Optional.empty();
        private Optional<LocationStatus> status = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> merchantId = Optional.empty();
        private Optional<Country> country = Optional.empty();
        private Optional<String> languageCode = Optional.empty();
        private Optional<Currency> currency = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> businessName = Optional.empty();
        private Optional<LocationType> type = Optional.empty();
        private Optional<String> websiteUrl = Optional.empty();
        private Optional<BusinessHours> businessHours = Optional.empty();
        private Optional<String> businessEmail = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> twitterUsername = Optional.empty();
        private Optional<String> instagramUsername = Optional.empty();
        private Optional<String> facebookUrl = Optional.empty();
        private Optional<Coordinates> coordinates = Optional.empty();
        private Optional<String> logoUrl = Optional.empty();
        private Optional<String> posBackgroundUrl = Optional.empty();
        private Optional<String> mcc = Optional.empty();
        private Optional<String> fullFormatLogoUrl = Optional.empty();
        private Optional<TaxIds> taxIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Location other) {
            this.id(other.getId());
            this.name(other.getName());
            this.address(other.getAddress());
            this.timezone(other.getTimezone());
            this.capabilities(other.getCapabilities());
            this.status(other.getStatus());
            this.createdAt(other.getCreatedAt());
            this.merchantId(other.getMerchantId());
            this.country(other.getCountry());
            this.languageCode(other.getLanguageCode());
            this.currency(other.getCurrency());
            this.phoneNumber(other.getPhoneNumber());
            this.businessName(other.getBusinessName());
            this.type(other.getType());
            this.websiteUrl(other.getWebsiteUrl());
            this.businessHours(other.getBusinessHours());
            this.businessEmail(other.getBusinessEmail());
            this.description(other.getDescription());
            this.twitterUsername(other.getTwitterUsername());
            this.instagramUsername(other.getInstagramUsername());
            this.facebookUrl(other.getFacebookUrl());
            this.coordinates(other.getCoordinates());
            this.logoUrl(other.getLogoUrl());
            this.posBackgroundUrl(other.getPosBackgroundUrl());
            this.mcc(other.getMcc());
            this.fullFormatLogoUrl(other.getFullFormatLogoUrl());
            this.taxIds(other.getTaxIds());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="address", nulls=Nulls.SKIP)
        public Builder address(Optional<Address> address) {
            this.address = address;
            return this;
        }

        public Builder address(Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        @JsonSetter(value="timezone", nulls=Nulls.SKIP)
        public Builder timezone(Optional<String> timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = Optional.ofNullable(timezone);
            return this;
        }

        public Builder timezone(Nullable<String> timezone) {
            this.timezone = timezone.isNull() ? null : (timezone.isEmpty() ? Optional.empty() : Optional.of(timezone.get()));
            return this;
        }

        @JsonSetter(value="capabilities", nulls=Nulls.SKIP)
        public Builder capabilities(Optional<List<LocationCapability>> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder capabilities(List<LocationCapability> capabilities) {
            this.capabilities = Optional.ofNullable(capabilities);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<LocationStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(LocationStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="merchant_id", nulls=Nulls.SKIP)
        public Builder merchantId(Optional<String> merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = Optional.ofNullable(merchantId);
            return this;
        }

        @JsonSetter(value="country", nulls=Nulls.SKIP)
        public Builder country(Optional<Country> country) {
            this.country = country;
            return this;
        }

        public Builder country(Country country) {
            this.country = Optional.ofNullable(country);
            return this;
        }

        @JsonSetter(value="language_code", nulls=Nulls.SKIP)
        public Builder languageCode(Optional<String> languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = Optional.ofNullable(languageCode);
            return this;
        }

        public Builder languageCode(Nullable<String> languageCode) {
            this.languageCode = languageCode.isNull() ? null : (languageCode.isEmpty() ? Optional.empty() : Optional.of(languageCode.get()));
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<Currency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumber(Nullable<String> phoneNumber) {
            this.phoneNumber = phoneNumber.isNull() ? null : (phoneNumber.isEmpty() ? Optional.empty() : Optional.of(phoneNumber.get()));
            return this;
        }

        @JsonSetter(value="business_name", nulls=Nulls.SKIP)
        public Builder businessName(Optional<String> businessName) {
            this.businessName = businessName;
            return this;
        }

        public Builder businessName(String businessName) {
            this.businessName = Optional.ofNullable(businessName);
            return this;
        }

        public Builder businessName(Nullable<String> businessName) {
            this.businessName = businessName.isNull() ? null : (businessName.isEmpty() ? Optional.empty() : Optional.of(businessName.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<LocationType> type) {
            this.type = type;
            return this;
        }

        public Builder type(LocationType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="website_url", nulls=Nulls.SKIP)
        public Builder websiteUrl(Optional<String> websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = Optional.ofNullable(websiteUrl);
            return this;
        }

        public Builder websiteUrl(Nullable<String> websiteUrl) {
            this.websiteUrl = websiteUrl.isNull() ? null : (websiteUrl.isEmpty() ? Optional.empty() : Optional.of(websiteUrl.get()));
            return this;
        }

        @JsonSetter(value="business_hours", nulls=Nulls.SKIP)
        public Builder businessHours(Optional<BusinessHours> businessHours) {
            this.businessHours = businessHours;
            return this;
        }

        public Builder businessHours(BusinessHours businessHours) {
            this.businessHours = Optional.ofNullable(businessHours);
            return this;
        }

        @JsonSetter(value="business_email", nulls=Nulls.SKIP)
        public Builder businessEmail(Optional<String> businessEmail) {
            this.businessEmail = businessEmail;
            return this;
        }

        public Builder businessEmail(String businessEmail) {
            this.businessEmail = Optional.ofNullable(businessEmail);
            return this;
        }

        public Builder businessEmail(Nullable<String> businessEmail) {
            this.businessEmail = businessEmail.isNull() ? null : (businessEmail.isEmpty() ? Optional.empty() : Optional.of(businessEmail.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @JsonSetter(value="twitter_username", nulls=Nulls.SKIP)
        public Builder twitterUsername(Optional<String> twitterUsername) {
            this.twitterUsername = twitterUsername;
            return this;
        }

        public Builder twitterUsername(String twitterUsername) {
            this.twitterUsername = Optional.ofNullable(twitterUsername);
            return this;
        }

        public Builder twitterUsername(Nullable<String> twitterUsername) {
            this.twitterUsername = twitterUsername.isNull() ? null : (twitterUsername.isEmpty() ? Optional.empty() : Optional.of(twitterUsername.get()));
            return this;
        }

        @JsonSetter(value="instagram_username", nulls=Nulls.SKIP)
        public Builder instagramUsername(Optional<String> instagramUsername) {
            this.instagramUsername = instagramUsername;
            return this;
        }

        public Builder instagramUsername(String instagramUsername) {
            this.instagramUsername = Optional.ofNullable(instagramUsername);
            return this;
        }

        public Builder instagramUsername(Nullable<String> instagramUsername) {
            this.instagramUsername = instagramUsername.isNull() ? null : (instagramUsername.isEmpty() ? Optional.empty() : Optional.of(instagramUsername.get()));
            return this;
        }

        @JsonSetter(value="facebook_url", nulls=Nulls.SKIP)
        public Builder facebookUrl(Optional<String> facebookUrl) {
            this.facebookUrl = facebookUrl;
            return this;
        }

        public Builder facebookUrl(String facebookUrl) {
            this.facebookUrl = Optional.ofNullable(facebookUrl);
            return this;
        }

        public Builder facebookUrl(Nullable<String> facebookUrl) {
            this.facebookUrl = facebookUrl.isNull() ? null : (facebookUrl.isEmpty() ? Optional.empty() : Optional.of(facebookUrl.get()));
            return this;
        }

        @JsonSetter(value="coordinates", nulls=Nulls.SKIP)
        public Builder coordinates(Optional<Coordinates> coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Builder coordinates(Coordinates coordinates) {
            this.coordinates = Optional.ofNullable(coordinates);
            return this;
        }

        @JsonSetter(value="logo_url", nulls=Nulls.SKIP)
        public Builder logoUrl(Optional<String> logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public Builder logoUrl(String logoUrl) {
            this.logoUrl = Optional.ofNullable(logoUrl);
            return this;
        }

        @JsonSetter(value="pos_background_url", nulls=Nulls.SKIP)
        public Builder posBackgroundUrl(Optional<String> posBackgroundUrl) {
            this.posBackgroundUrl = posBackgroundUrl;
            return this;
        }

        public Builder posBackgroundUrl(String posBackgroundUrl) {
            this.posBackgroundUrl = Optional.ofNullable(posBackgroundUrl);
            return this;
        }

        @JsonSetter(value="mcc", nulls=Nulls.SKIP)
        public Builder mcc(Optional<String> mcc) {
            this.mcc = mcc;
            return this;
        }

        public Builder mcc(String mcc) {
            this.mcc = Optional.ofNullable(mcc);
            return this;
        }

        public Builder mcc(Nullable<String> mcc) {
            this.mcc = mcc.isNull() ? null : (mcc.isEmpty() ? Optional.empty() : Optional.of(mcc.get()));
            return this;
        }

        @JsonSetter(value="full_format_logo_url", nulls=Nulls.SKIP)
        public Builder fullFormatLogoUrl(Optional<String> fullFormatLogoUrl) {
            this.fullFormatLogoUrl = fullFormatLogoUrl;
            return this;
        }

        public Builder fullFormatLogoUrl(String fullFormatLogoUrl) {
            this.fullFormatLogoUrl = Optional.ofNullable(fullFormatLogoUrl);
            return this;
        }

        @JsonSetter(value="tax_ids", nulls=Nulls.SKIP)
        public Builder taxIds(Optional<TaxIds> taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public Builder taxIds(TaxIds taxIds) {
            this.taxIds = Optional.ofNullable(taxIds);
            return this;
        }

        public Location build() {
            return new Location(this.id, this.name, this.address, this.timezone, this.capabilities, this.status, this.createdAt, this.merchantId, this.country, this.languageCode, this.currency, this.phoneNumber, this.businessName, this.type, this.websiteUrl, this.businessHours, this.businessEmail, this.description, this.twitterUsername, this.instagramUsername, this.facebookUrl, this.coordinates, this.logoUrl, this.posBackgroundUrl, this.mcc, this.fullFormatLogoUrl, this.taxIds, this.additionalProperties);
        }
    }
}

