/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.WebhookSubscription;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListWebhookSubscriptionsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<WebhookSubscription>> subscriptions;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListWebhookSubscriptionsResponse(Optional<List<Error>> errors, Optional<List<WebhookSubscription>> subscriptions, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.subscriptions = subscriptions;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="subscriptions")
    public Optional<List<WebhookSubscription>> getSubscriptions() {
        return this.subscriptions;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListWebhookSubscriptionsResponse && this.equalTo((ListWebhookSubscriptionsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListWebhookSubscriptionsResponse other) {
        return this.errors.equals(other.errors) && this.subscriptions.equals(other.subscriptions) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscriptions, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<WebhookSubscription>> subscriptions = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListWebhookSubscriptionsResponse other) {
            this.errors(other.getErrors());
            this.subscriptions(other.getSubscriptions());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="subscriptions", nulls=Nulls.SKIP)
        public Builder subscriptions(Optional<List<WebhookSubscription>> subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        public Builder subscriptions(List<WebhookSubscription> subscriptions) {
            this.subscriptions = Optional.ofNullable(subscriptions);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public ListWebhookSubscriptionsResponse build() {
            return new ListWebhookSubscriptionsResponse(this.errors, this.subscriptions, this.cursor, this.additionalProperties);
        }
    }
}

