/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.SubscriptionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListSubscriptionEventsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<SubscriptionEvent>> subscriptionEvents;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListSubscriptionEventsResponse(Optional<List<Error>> errors, Optional<List<SubscriptionEvent>> subscriptionEvents, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.subscriptionEvents = subscriptionEvents;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="subscription_events")
    public Optional<List<SubscriptionEvent>> getSubscriptionEvents() {
        return this.subscriptionEvents;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListSubscriptionEventsResponse && this.equalTo((ListSubscriptionEventsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListSubscriptionEventsResponse other) {
        return this.errors.equals(other.errors) && this.subscriptionEvents.equals(other.subscriptionEvents) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscriptionEvents, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<SubscriptionEvent>> subscriptionEvents = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListSubscriptionEventsResponse other) {
            this.errors(other.getErrors());
            this.subscriptionEvents(other.getSubscriptionEvents());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="subscription_events", nulls=Nulls.SKIP)
        public Builder subscriptionEvents(Optional<List<SubscriptionEvent>> subscriptionEvents) {
            this.subscriptionEvents = subscriptionEvents;
            return this;
        }

        public Builder subscriptionEvents(List<SubscriptionEvent> subscriptionEvents) {
            this.subscriptionEvents = Optional.ofNullable(subscriptionEvents);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public ListSubscriptionEventsResponse build() {
            return new ListSubscriptionEventsResponse(this.errors, this.subscriptionEvents, this.cursor, this.additionalProperties);
        }
    }
}

