/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ListPaymentRefundsRequestSortField;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListRefundsRequest {
    private final Optional<String> beginTime;
    private final Optional<String> endTime;
    private final Optional<String> sortOrder;
    private final Optional<String> cursor;
    private final Optional<String> locationId;
    private final Optional<String> status;
    private final Optional<String> sourceType;
    private final Optional<Integer> limit;
    private final Optional<String> updatedAtBeginTime;
    private final Optional<String> updatedAtEndTime;
    private final Optional<ListPaymentRefundsRequestSortField> sortField;
    private final Map<String, Object> additionalProperties;

    private ListRefundsRequest(Optional<String> beginTime, Optional<String> endTime, Optional<String> sortOrder, Optional<String> cursor, Optional<String> locationId, Optional<String> status, Optional<String> sourceType, Optional<Integer> limit, Optional<String> updatedAtBeginTime, Optional<String> updatedAtEndTime, Optional<ListPaymentRefundsRequestSortField> sortField, Map<String, Object> additionalProperties) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.sortOrder = sortOrder;
        this.cursor = cursor;
        this.locationId = locationId;
        this.status = status;
        this.sourceType = sourceType;
        this.limit = limit;
        this.updatedAtBeginTime = updatedAtBeginTime;
        this.updatedAtEndTime = updatedAtEndTime;
        this.sortField = sortField;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getBeginTime() {
        if (this.beginTime == null) {
            return Optional.empty();
        }
        return this.beginTime;
    }

    @JsonIgnore
    public Optional<String> getEndTime() {
        if (this.endTime == null) {
            return Optional.empty();
        }
        return this.endTime;
    }

    @JsonIgnore
    public Optional<String> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        return this.status;
    }

    @JsonIgnore
    public Optional<String> getSourceType() {
        if (this.sourceType == null) {
            return Optional.empty();
        }
        return this.sourceType;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<String> getUpdatedAtBeginTime() {
        if (this.updatedAtBeginTime == null) {
            return Optional.empty();
        }
        return this.updatedAtBeginTime;
    }

    @JsonIgnore
    public Optional<String> getUpdatedAtEndTime() {
        if (this.updatedAtEndTime == null) {
            return Optional.empty();
        }
        return this.updatedAtEndTime;
    }

    @JsonIgnore
    public Optional<ListPaymentRefundsRequestSortField> getSortField() {
        if (this.sortField == null) {
            return Optional.empty();
        }
        return this.sortField;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="begin_time")
    private Optional<String> _getBeginTime() {
        return this.beginTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_time")
    private Optional<String> _getEndTime() {
        return this.endTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<String> _getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status")
    private Optional<String> _getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_type")
    private Optional<String> _getSourceType() {
        return this.sourceType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="updated_at_begin_time")
    private Optional<String> _getUpdatedAtBeginTime() {
        return this.updatedAtBeginTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="updated_at_end_time")
    private Optional<String> _getUpdatedAtEndTime() {
        return this.updatedAtEndTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_field")
    private Optional<ListPaymentRefundsRequestSortField> _getSortField() {
        return this.sortField;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListRefundsRequest && this.equalTo((ListRefundsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListRefundsRequest other) {
        return this.beginTime.equals(other.beginTime) && this.endTime.equals(other.endTime) && this.sortOrder.equals(other.sortOrder) && this.cursor.equals(other.cursor) && this.locationId.equals(other.locationId) && this.status.equals(other.status) && this.sourceType.equals(other.sourceType) && this.limit.equals(other.limit) && this.updatedAtBeginTime.equals(other.updatedAtBeginTime) && this.updatedAtEndTime.equals(other.updatedAtEndTime) && this.sortField.equals(other.sortField);
    }

    public int hashCode() {
        return Objects.hash(this.beginTime, this.endTime, this.sortOrder, this.cursor, this.locationId, this.status, this.sourceType, this.limit, this.updatedAtBeginTime, this.updatedAtEndTime, this.sortField);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> beginTime = Optional.empty();
        private Optional<String> endTime = Optional.empty();
        private Optional<String> sortOrder = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> status = Optional.empty();
        private Optional<String> sourceType = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> updatedAtBeginTime = Optional.empty();
        private Optional<String> updatedAtEndTime = Optional.empty();
        private Optional<ListPaymentRefundsRequestSortField> sortField = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListRefundsRequest other) {
            this.beginTime(other.getBeginTime());
            this.endTime(other.getEndTime());
            this.sortOrder(other.getSortOrder());
            this.cursor(other.getCursor());
            this.locationId(other.getLocationId());
            this.status(other.getStatus());
            this.sourceType(other.getSourceType());
            this.limit(other.getLimit());
            this.updatedAtBeginTime(other.getUpdatedAtBeginTime());
            this.updatedAtEndTime(other.getUpdatedAtEndTime());
            this.sortField(other.getSortField());
            return this;
        }

        @JsonSetter(value="begin_time", nulls=Nulls.SKIP)
        public Builder beginTime(Optional<String> beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = Optional.ofNullable(beginTime);
            return this;
        }

        public Builder beginTime(Nullable<String> beginTime) {
            this.beginTime = beginTime.isNull() ? null : (beginTime.isEmpty() ? Optional.empty() : Optional.of(beginTime.get()));
            return this;
        }

        @JsonSetter(value="end_time", nulls=Nulls.SKIP)
        public Builder endTime(Optional<String> endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = Optional.ofNullable(endTime);
            return this;
        }

        public Builder endTime(Nullable<String> endTime) {
            this.endTime = endTime.isNull() ? null : (endTime.isEmpty() ? Optional.empty() : Optional.of(endTime.get()));
            return this;
        }

        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public Builder sortOrder(Optional<String> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<String> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Nullable<String> status) {
            this.status = status.isNull() ? null : (status.isEmpty() ? Optional.empty() : Optional.of(status.get()));
            return this;
        }

        @JsonSetter(value="source_type", nulls=Nulls.SKIP)
        public Builder sourceType(Optional<String> sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = Optional.ofNullable(sourceType);
            return this;
        }

        public Builder sourceType(Nullable<String> sourceType) {
            this.sourceType = sourceType.isNull() ? null : (sourceType.isEmpty() ? Optional.empty() : Optional.of(sourceType.get()));
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @JsonSetter(value="updated_at_begin_time", nulls=Nulls.SKIP)
        public Builder updatedAtBeginTime(Optional<String> updatedAtBeginTime) {
            this.updatedAtBeginTime = updatedAtBeginTime;
            return this;
        }

        public Builder updatedAtBeginTime(String updatedAtBeginTime) {
            this.updatedAtBeginTime = Optional.ofNullable(updatedAtBeginTime);
            return this;
        }

        public Builder updatedAtBeginTime(Nullable<String> updatedAtBeginTime) {
            this.updatedAtBeginTime = updatedAtBeginTime.isNull() ? null : (updatedAtBeginTime.isEmpty() ? Optional.empty() : Optional.of(updatedAtBeginTime.get()));
            return this;
        }

        @JsonSetter(value="updated_at_end_time", nulls=Nulls.SKIP)
        public Builder updatedAtEndTime(Optional<String> updatedAtEndTime) {
            this.updatedAtEndTime = updatedAtEndTime;
            return this;
        }

        public Builder updatedAtEndTime(String updatedAtEndTime) {
            this.updatedAtEndTime = Optional.ofNullable(updatedAtEndTime);
            return this;
        }

        public Builder updatedAtEndTime(Nullable<String> updatedAtEndTime) {
            this.updatedAtEndTime = updatedAtEndTime.isNull() ? null : (updatedAtEndTime.isEmpty() ? Optional.empty() : Optional.of(updatedAtEndTime.get()));
            return this;
        }

        @JsonSetter(value="sort_field", nulls=Nulls.SKIP)
        public Builder sortField(Optional<ListPaymentRefundsRequestSortField> sortField) {
            this.sortField = sortField;
            return this;
        }

        public Builder sortField(ListPaymentRefundsRequestSortField sortField) {
            this.sortField = Optional.ofNullable(sortField);
            return this;
        }

        public Builder sortField(Nullable<ListPaymentRefundsRequestSortField> sortField) {
            this.sortField = sortField.isNull() ? null : (sortField.isEmpty() ? Optional.empty() : Optional.of(sortField.get()));
            return this;
        }

        public ListRefundsRequest build() {
            return new ListRefundsRequest(this.beginTime, this.endTime, this.sortOrder, this.cursor, this.locationId, this.status, this.sourceType, this.limit, this.updatedAtBeginTime, this.updatedAtEndTime, this.sortField, this.additionalProperties);
        }
    }
}

